/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SLF4JLogFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.ILoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.logback.LogbackLoggingSystem;
import org.springframework.boot.test.OutputCapture;
import org.springframework.util.StringUtils;

public class LogbackLoggingSystemTests {
    @Rule
    public OutputCapture output = new OutputCapture();
    private final LogbackLoggingSystem loggingSystem = new LogbackLoggingSystem(this.getClass().getClassLoader());
    private Log logger;

    @Before
    public void setup() {
        this.logger = new SLF4JLogFactory().getInstance(this.getClass().getName());
        new File(this.tmpDir() + "/spring.log").delete();
    }

    private String tmpDir() {
        return System.getProperty("java.io.tmpdir");
    }

    @After
    public void clear() {
        System.clearProperty("LOG_FILE");
        System.clearProperty("LOG_PATH");
        System.clearProperty("PID");
    }

    @Test
    public void testBasicConfigLocation() throws Exception {
        this.loggingSystem.beforeInitialize();
        ILoggerFactory factory = StaticLoggerBinder.getSingleton().getLoggerFactory();
        LoggerContext context = (LoggerContext)factory;
        Logger root = context.getLogger("ROOT");
        Assert.assertNotNull((Object)root.getAppender("CONSOLE"));
    }

    @Test
    public void testNonDefaultConfigLocation() throws Exception {
        this.loggingSystem.beforeInitialize();
        this.loggingSystem.initialize("classpath:logback-nondefault.xml");
        this.logger.info((Object)"Hello world");
        String output = this.output.toString().trim();
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.contains("Hello world"));
        Assert.assertTrue((String)("Wrong output (not " + this.tmpDir() + " :\n" + output), (boolean)output.contains(this.tmpDir() + "/tmp.log"));
        Assert.assertFalse((boolean)new File(this.tmpDir() + "/tmp.log").exists());
    }

    @Test(expected=IllegalStateException.class)
    public void testNonexistentConfigLocation() throws Exception {
        this.loggingSystem.beforeInitialize();
        this.loggingSystem.initialize("classpath:logback-nonexistent.xml");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullConfigLocation() throws Exception {
        this.loggingSystem.beforeInitialize();
        this.loggingSystem.initialize(null);
    }

    @Test
    public void setLevel() throws Exception {
        this.loggingSystem.beforeInitialize();
        this.loggingSystem.initialize();
        this.logger.debug((Object)"Hello");
        this.loggingSystem.setLogLevel("org.springframework.boot", LogLevel.DEBUG);
        this.logger.debug((Object)"Hello");
        Assert.assertThat((Object)StringUtils.countOccurrencesOf((String)this.output.toString(), (String)"Hello"), (Matcher)Matchers.equalTo((Object)1));
    }
}

