/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.logging.logback.WhitespaceThrowableProxyConverter;

public class WhitespaceThrowableProxyConverterTests {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final WhitespaceThrowableProxyConverter converter = new WhitespaceThrowableProxyConverter();
    private final LoggingEvent event = new LoggingEvent();

    @Test
    public void noStackTrace() throws Exception {
        String s = this.converter.convert((ILoggingEvent)this.event);
        Assert.assertThat((Object)s, (Matcher)Matchers.equalTo((Object)""));
    }

    @Test
    public void withStackTrace() throws Exception {
        this.event.setThrowableProxy(new ThrowableProxy((Throwable)new RuntimeException()));
        String s = this.converter.convert((ILoggingEvent)this.event);
        Assert.assertThat((Object)s, (Matcher)Matchers.startsWith((String)LINE_SEPARATOR));
        Assert.assertThat((Object)s, (Matcher)Matchers.endsWith((String)LINE_SEPARATOR));
    }
}

