/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.yaml;

import java.io.IOException;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.yaml.ArrayDocumentMatcher;
import org.springframework.boot.yaml.YamlProcessor;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class ArrayDocumentMatcherTests {
    @Test
    public void testMatchesSingleValue() throws IOException {
        ArrayDocumentMatcher matcher = new ArrayDocumentMatcher("foo", new String[]{"bar"});
        Assert.assertEquals((Object)YamlProcessor.MatchStatus.FOUND, (Object)matcher.matches(this.getProperties("foo: bar")));
    }

    @Test
    public void testDoesNotMatchesIndexedArray() throws IOException {
        ArrayDocumentMatcher matcher = new ArrayDocumentMatcher("foo", new String[]{"bar"});
        Assert.assertEquals((Object)YamlProcessor.MatchStatus.ABSTAIN, (Object)matcher.matches(this.getProperties("foo[0]: bar\nfoo[1]: spam")));
    }

    @Test
    public void testMatchesCommaSeparatedArray() throws IOException {
        ArrayDocumentMatcher matcher = new ArrayDocumentMatcher("foo", new String[]{"bar"});
        Assert.assertEquals((Object)YamlProcessor.MatchStatus.FOUND, (Object)matcher.matches(this.getProperties("foo: bar,spam")));
    }

    private Properties getProperties(String values) throws IOException {
        return PropertiesLoaderUtils.loadProperties((Resource)new ByteArrayResource(values.getBytes()));
    }
}

