/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.yaml;

import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.springframework.boot.yaml.YamlProcessor;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.scanner.ScannerException;

public class YamlProcessorTests {
    private final YamlProcessor processor = new YamlProcessor(){};
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void arrayConvertedToIndexedBeanReference() {
        this.processor.setResources(new Resource[]{new ByteArrayResource("foo: bar\nbar: [1,2,3]".getBytes())});
        this.processor.process(new YamlProcessor.MatchCallback(){

            public void process(Properties properties, Map<String, Object> map) {
                Assert.assertEquals((Object)1, (Object)properties.get("bar[0]"));
                Assert.assertEquals((Object)2, (Object)properties.get("bar[1]"));
                Assert.assertEquals((Object)3, (Object)properties.get("bar[2]"));
                Assert.assertEquals((long)4L, (long)properties.size());
            }
        });
    }

    @Test
    public void testStringResource() throws Exception {
        this.processor.setResources(new Resource[]{new ByteArrayResource("foo # a document that is a literal".getBytes())});
        this.processor.process(new YamlProcessor.MatchCallback(){

            public void process(Properties properties, Map<String, Object> map) {
                Assert.assertEquals((Object)"foo", (Object)map.get("document"));
            }
        });
    }

    @Test
    public void testBadDocumentStart() throws Exception {
        this.processor.setResources(new Resource[]{new ByteArrayResource("foo # a document\nbar: baz".getBytes())});
        this.exception.expect(ParserException.class);
        this.exception.expectMessage("line 2, column 1");
        this.processor.process(new YamlProcessor.MatchCallback(){

            public void process(Properties properties, Map<String, Object> map) {
            }
        });
    }

    @Test
    public void testBadResource() throws Exception {
        this.processor.setResources(new Resource[]{new ByteArrayResource("foo: bar\ncd\nspam:\n  foo: baz".getBytes())});
        this.exception.expect(ScannerException.class);
        this.exception.expectMessage("line 3, column 1");
        this.processor.process(new YamlProcessor.MatchCallback(){

            public void process(Properties properties, Map<String, Object> map) {
            }
        });
    }

    @Test
    public void mapConvertedToIndexedBeanReference() {
        this.processor.setResources(new Resource[]{new ByteArrayResource("foo: bar\nbar:\n spam: bucket".getBytes())});
        this.processor.process(new YamlProcessor.MatchCallback(){

            public void process(Properties properties, Map<String, Object> map) {
                Assert.assertEquals((Object)"bucket", (Object)properties.get("bar.spam"));
                Assert.assertEquals((long)2L, (long)properties.size());
            }
        });
    }

    @Test
    public void integerKeyBehaves() {
        this.processor.setResources(new Resource[]{new ByteArrayResource("foo: bar\n1: bar".getBytes())});
        this.processor.process(new YamlProcessor.MatchCallback(){

            public void process(Properties properties, Map<String, Object> map) {
                Assert.assertEquals((Object)"bar", (Object)properties.get("[1]"));
                Assert.assertEquals((long)2L, (long)properties.size());
            }
        });
    }

    @Test
    public void integerDeepKeyBehaves() {
        this.processor.setResources(new Resource[]{new ByteArrayResource("foo:\n  1: bar".getBytes())});
        this.processor.process(new YamlProcessor.MatchCallback(){

            public void process(Properties properties, Map<String, Object> map) {
                Assert.assertEquals((Object)"bar", (Object)properties.get("foo[1]"));
                Assert.assertEquals((long)1L, (long)properties.size());
            }
        });
    }
}

