/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedContext;
import org.springframework.util.Assert;

class SkipPatternJarScanner
implements JarScanner {
    private final JarScanner jarScanner;
    private final SkipPattern pattern;

    SkipPatternJarScanner(JarScanner jarScanner, String pattern) {
        Assert.notNull((Object)jarScanner, (String)"JarScanner must not be null");
        this.jarScanner = jarScanner;
        this.pattern = pattern == null ? new SkipPattern() : new SkipPattern(pattern);
    }

    public void scan(ServletContext context, ClassLoader classloader, JarScannerCallback callback, Set<String> jarsToSkip) {
        this.jarScanner.scan(context, classloader, callback, jarsToSkip == null ? this.pattern.asSet() : jarsToSkip);
    }

    public static void apply(TomcatEmbeddedContext context, String pattern) {
        context.setJarScanner(new SkipPatternJarScanner(context.getJarScanner(), pattern));
    }

    private static class SkipPattern {
        private Set<String> patterns = new LinkedHashSet<String>();

        protected SkipPattern() {
            this.add("ant-*.jar");
            this.add("aspectj*.jar");
            this.add("commons-beanutils*.jar");
            this.add("commons-codec*.jar");
            this.add("commons-collections*.jar");
            this.add("commons-dbcp*.jar");
            this.add("commons-digester*.jar");
            this.add("commons-fileupload*.jar");
            this.add("commons-httpclient*.jar");
            this.add("commons-io*.jar");
            this.add("commons-lang*.jar");
            this.add("commons-logging*.jar");
            this.add("commons-math*.jar");
            this.add("commons-pool*.jar");
            this.add("geronimo-spec-jaxrpc*.jar");
            this.add("h2*.jar");
            this.add("hamcrest*.jar");
            this.add("hibernate*.jar");
            this.add("jmx*.jar");
            this.add("jmx-tools-*.jar");
            this.add("jta*.jar");
            this.add("junit-*.jar");
            this.add("httpclient*.jar");
            this.add("log4j-*.jar");
            this.add("mail*.jar");
            this.add("org.hamcrest*.jar");
            this.add("slf4j*.jar");
            this.add("tomcat-embed-core-*.jar");
            this.add("tomcat-embed-logging-*.jar");
            this.add("tomcat-jdbc-*.jar");
            this.add("tomcat-juli-*.jar");
            this.add("tools.jar");
            this.add("wsdl4j*.jar");
            this.add("xercesImpl-*.jar");
            this.add("xmlParserAPIs-*.jar");
            this.add("xml-apis-*.jar");
        }

        public SkipPattern(String patterns) {
            StringTokenizer tokenizer = new StringTokenizer(patterns, ",");
            while (tokenizer.hasMoreElements()) {
                this.add(tokenizer.nextToken());
            }
        }

        protected void add(String patterns) {
            Assert.notNull((Object)patterns, (String)"Patterns must not be null");
            if (patterns.length() > 0 && !patterns.trim().startsWith(",")) {
                this.patterns.add(",");
            }
            this.patterns.add(patterns);
        }

        public Set<String> asSet() {
            return Collections.unmodifiableSet(this.patterns);
        }
    }
}

