/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.spi.FilterReply;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.Marker;
import org.slf4j.impl.StaticLoggerBinder;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.Slf4JLoggingSystem;
import org.springframework.boot.logging.logback.DefaultLogbackConfiguration;
import org.springframework.boot.logging.logback.LogbackConfigurator;
import org.springframework.util.Assert;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class LogbackLoggingSystem
extends Slf4JLoggingSystem {
    private static final Map<LogLevel, Level> LEVELS;
    private static final TurboFilter FILTER;

    public LogbackLoggingSystem(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    protected String[] getStandardConfigLocations() {
        return new String[]{"logback-test.groovy", "logback-test.xml", "logback.groovy", "logback.xml"};
    }

    @Override
    public void beforeInitialize() {
        super.beforeInitialize();
        this.getLogger(null).getLoggerContext().getTurboFilterList().add((Object)FILTER);
        this.configureJBossLoggingToUseSlf4j();
    }

    @Override
    public void initialize(String configLocation, String logFile) {
        this.getLogger(null).getLoggerContext().getTurboFilterList().remove((Object)FILTER);
        super.initialize(configLocation, logFile);
    }

    @Override
    protected void loadDefaults(String logFile) {
        LoggerContext context = this.getLoggerContext();
        context.stop();
        context.reset();
        LogbackConfigurator configurator = new LogbackConfigurator(context);
        new DefaultLogbackConfiguration(logFile).apply(configurator);
    }

    @Override
    protected void loadConfiguration(String location, String logFile) {
        Assert.notNull((Object)location, (String)"Location must not be null");
        if (StringUtils.hasLength((String)logFile)) {
            System.setProperty("LOG_FILE", logFile);
        }
        LoggerContext context = this.getLoggerContext();
        context.stop();
        context.reset();
        try {
            URL url = ResourceUtils.getURL((String)location);
            new ContextInitializer(context).configureByResource(url);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize Logback logging from " + location, ex);
        }
    }

    private void configureJBossLoggingToUseSlf4j() {
        System.setProperty("org.jboss.logging.provider", "slf4j");
    }

    @Override
    public void setLogLevel(String loggerName, LogLevel level) {
        this.getLogger(loggerName).setLevel(LEVELS.get((Object)level));
    }

    private LoggerContext getLoggerContext() {
        ILoggerFactory factory = StaticLoggerBinder.getSingleton().getLoggerFactory();
        Assert.isInstanceOf(LoggerContext.class, (Object)factory, (String)String.format("LoggerFactory is not a Logback LoggerContext but Logback is on the classpath. Either remove Logback or the competing implementation (%s loaded from %s).", factory.getClass(), factory.getClass().getProtectionDomain().getCodeSource().getLocation()));
        return (LoggerContext)factory;
    }

    private Logger getLogger(String name) {
        ILoggerFactory factory = StaticLoggerBinder.getSingleton().getLoggerFactory();
        return (Logger)factory.getLogger(StringUtils.isEmpty((Object)name) ? "ROOT" : name);
    }

    static {
        HashMap<LogLevel, Level> levels = new HashMap<LogLevel, Level>();
        levels.put(LogLevel.TRACE, Level.TRACE);
        levels.put(LogLevel.DEBUG, Level.DEBUG);
        levels.put(LogLevel.INFO, Level.INFO);
        levels.put(LogLevel.WARN, Level.WARN);
        levels.put(LogLevel.ERROR, Level.ERROR);
        levels.put(LogLevel.FATAL, Level.ERROR);
        levels.put(LogLevel.OFF, Level.OFF);
        LEVELS = Collections.unmodifiableMap(levels);
        FILTER = new TurboFilter(){

            public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
                return FilterReply.DENY;
            }
        };
    }
}

