/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.scan.StandardJarScanFilter;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class SkipPatternJarScanner
extends StandardJarScanner {
    private static final String JAR_SCAN_FILTER_CLASS = "org.apache.tomcat.JarScanFilter";
    private final JarScanner jarScanner;
    private final SkipPattern pattern;

    SkipPatternJarScanner(JarScanner jarScanner, String pattern) {
        Assert.notNull((Object)jarScanner, (String)"JarScanner must not be null");
        this.jarScanner = jarScanner;
        this.pattern = pattern == null ? new SkipPattern() : new SkipPattern(pattern);
        this.setPatternToTomcat8SkipFilter(this.pattern);
    }

    private void setPatternToTomcat8SkipFilter(SkipPattern pattern) {
        if (ClassUtils.isPresent((String)JAR_SCAN_FILTER_CLASS, null)) {
            new Tomcat8TldSkipSetter(this).setSkipPattern(pattern);
        }
    }

    public void scan(ServletContext context, ClassLoader classloader, JarScannerCallback callback, Set<String> jarsToSkip) {
        Method scanMethod = ReflectionUtils.findMethod(this.jarScanner.getClass(), (String)"scan", (Class[])new Class[]{ServletContext.class, ClassLoader.class, JarScannerCallback.class, Set.class});
        Assert.notNull((Object)scanMethod, (String)"Unable to find scan method");
        try {
            scanMethod.invoke((Object)this.jarScanner, context, classloader, callback, jarsToSkip == null ? this.pattern.asSet() : jarsToSkip);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Tomcat 7 reflection failed", ex);
        }
    }

    public static void apply(TomcatEmbeddedContext context, String pattern) {
        SkipPatternJarScanner scanner = new SkipPatternJarScanner(context.getJarScanner(), pattern);
        context.setJarScanner((JarScanner)scanner);
    }

    private static class SkipPattern {
        private Set<String> patterns = new LinkedHashSet<String>();

        protected SkipPattern() {
            this.add("ant-*.jar");
            this.add("aspectj*.jar");
            this.add("commons-beanutils*.jar");
            this.add("commons-codec*.jar");
            this.add("commons-collections*.jar");
            this.add("commons-dbcp*.jar");
            this.add("commons-digester*.jar");
            this.add("commons-fileupload*.jar");
            this.add("commons-httpclient*.jar");
            this.add("commons-io*.jar");
            this.add("commons-lang*.jar");
            this.add("commons-logging*.jar");
            this.add("commons-math*.jar");
            this.add("commons-pool*.jar");
            this.add("geronimo-spec-jaxrpc*.jar");
            this.add("h2*.jar");
            this.add("hamcrest*.jar");
            this.add("hibernate*.jar");
            this.add("jmx*.jar");
            this.add("jmx-tools-*.jar");
            this.add("jta*.jar");
            this.add("junit-*.jar");
            this.add("httpclient*.jar");
            this.add("log4j-*.jar");
            this.add("mail*.jar");
            this.add("org.hamcrest*.jar");
            this.add("slf4j*.jar");
            this.add("tomcat-embed-core-*.jar");
            this.add("tomcat-embed-logging-*.jar");
            this.add("tomcat-jdbc-*.jar");
            this.add("tomcat-juli-*.jar");
            this.add("tools.jar");
            this.add("wsdl4j*.jar");
            this.add("xercesImpl-*.jar");
            this.add("xmlParserAPIs-*.jar");
            this.add("xml-apis-*.jar");
            this.add("antlr-*.jar");
            this.add("aopalliance-*.jar");
            this.add("aspectjrt-*.jar");
            this.add("aspectjweaver-*.jar");
            this.add("classmate-*.jar");
            this.add("dom4j-*.jar");
            this.add("ecj-*.jar");
            this.add("ehcache-core-*.jar");
            this.add("hibernate-core-*.jar");
            this.add("hibernate-commons-annotations-*.jar");
            this.add("hibernate-entitymanager-*.jar");
            this.add("hibernate-jpa-2.1-api-*.jar");
            this.add("hibernate-validator-*.jar");
            this.add("hsqldb-*.jar");
            this.add("jackson-annotations-*.jar");
            this.add("jackson-core-*.jar");
            this.add("jackson-databind-*.jar");
            this.add("jandex-*.jar");
            this.add("javassist-*.jar");
            this.add("jboss-logging-*.jar");
            this.add("jboss-transaction-api_*.jar");
            this.add("jcl-over-slf4j-*.jar");
            this.add("jdom-*.jar");
            this.add("joda-time-*.jar");
            this.add("jul-to-slf4j-*.jar");
            this.add("log4j-over-slf4j-*.jar");
            this.add("logback-classic-*.jar");
            this.add("logback-core-*.jar");
            this.add("rome-*.jar");
            this.add("slf4j-api-*.jar");
            this.add("spring-aop-*.jar");
            this.add("spring-aspects-*.jar");
            this.add("spring-beans-*.jar");
            this.add("spring-boot-*.jar");
            this.add("spring-core-*.jar");
            this.add("spring-context-*.jar");
            this.add("spring-data-*.jar");
            this.add("spring-expression-*.jar");
            this.add("spring-jdbc-*.jar,");
            this.add("spring-orm-*.jar");
            this.add("spring-oxm-*.jar");
            this.add("spring-tx-*.jar");
            this.add("snakeyaml-*.jar");
            this.add("tomcat-embed-el-*.jar");
            this.add("validation-api-*.jar");
            this.add("xml-apis-*.jar");
        }

        public SkipPattern(String patterns) {
            StringTokenizer tokenizer = new StringTokenizer(patterns, ",");
            while (tokenizer.hasMoreElements()) {
                this.add(tokenizer.nextToken());
            }
        }

        protected void add(String patterns) {
            Assert.notNull((Object)patterns, (String)"Patterns must not be null");
            if (patterns.length() > 0 && !patterns.trim().startsWith(",")) {
                this.patterns.add(",");
            }
            this.patterns.add(patterns);
        }

        public String asCommaDelimitedString() {
            return StringUtils.collectionToCommaDelimitedString(this.patterns);
        }

        public Set<String> asSet() {
            return Collections.unmodifiableSet(this.patterns);
        }
    }

    private static class Tomcat8TldSkipSetter {
        private final StandardJarScanner jarScanner;

        public Tomcat8TldSkipSetter(StandardJarScanner jarScanner) {
            this.jarScanner = jarScanner;
        }

        public void setSkipPattern(SkipPattern pattern) {
            StandardJarScanFilter filter = new StandardJarScanFilter();
            filter.setTldSkip(pattern.asCommaDelimitedString());
            this.jarScanner.setJarScanFilter((JarScanFilter)filter);
        }
    }
}

