/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.test.IntegrationTest;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.util.ReflectionTestUtils;

class IntegrationTestPropertiesListener
extends AbstractTestExecutionListener {
    private static final String ANNOTATION_TYPE = IntegrationTest.class.getName();

    IntegrationTestPropertiesListener() {
    }

    public void prepareTestInstance(TestContext testContext) throws Exception {
        Class testClass = testContext.getTestClass();
        if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)testClass, (String)ANNOTATION_TYPE)) {
            AnnotationAttributes annotationAttributes = AnnotatedElementUtils.getAnnotationAttributes((AnnotatedElement)testClass, (String)ANNOTATION_TYPE);
            this.addPropertySourceProperties(testContext, annotationAttributes.getStringArray("value"));
        }
    }

    private void addPropertySourceProperties(TestContext testContext, String[] properties) {
        try {
            this.addPropertySourcePropertiesUsingReflection(testContext, properties);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void addPropertySourcePropertiesUsingReflection(TestContext testContext, String[] properties) throws Exception {
        MergedContextConfiguration configuration = (MergedContextConfiguration)ReflectionTestUtils.getField((Object)testContext, (String)"mergedContextConfiguration");
        LinkedHashSet<String> merged = new LinkedHashSet<String>(Arrays.asList(configuration.getPropertySourceProperties()));
        merged.addAll(Arrays.asList(properties));
        this.addIntegrationTestProperty(merged);
        ReflectionTestUtils.setField((Object)configuration, (String)"propertySourceProperties", (Object)merged.toArray(new String[merged.size()]));
    }

    private void addIntegrationTestProperty(Set<String> propertySourceProperties) {
        propertySourceProperties.add(IntegrationTest.class.getName() + "=true");
    }
}

