/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot;

import java.io.File;
import java.security.MessageDigest;
import org.springframework.boot.ApplicationHome;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ApplicationTemp {
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();
    private final Class<?> sourceClass;
    private volatile File folder;

    public ApplicationTemp() {
        this(null);
    }

    public ApplicationTemp(Class<?> sourceClass) {
        this.sourceClass = sourceClass;
    }

    public String toString() {
        return this.getFolder().getAbsolutePath();
    }

    public File getFolder(String subFolder) {
        File folder = new File(this.getFolder(), subFolder);
        folder.mkdirs();
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFolder() {
        if (this.folder == null) {
            ApplicationTemp applicationTemp = this;
            synchronized (applicationTemp) {
                byte[] hash = this.generateHash(this.sourceClass);
                this.folder = new File(this.getTempDirectory(), this.toHexString(hash));
                this.folder.mkdirs();
                Assert.state((boolean)this.folder.exists(), (String)("Unable to create temp folder " + this.folder));
            }
        }
        return this.folder;
    }

    private File getTempDirectory() {
        String property = System.getProperty("java.io.tmpdir");
        Assert.state((boolean)StringUtils.hasLength((String)property), (String)"No 'java.io.tmpdir' property set");
        File file = new File(property);
        Assert.state((boolean)file.exists(), (String)("Temp folder " + file + " does not exist"));
        Assert.state((boolean)file.isDirectory(), (String)("Temp location " + file + " is not a folder"));
        return file;
    }

    private byte[] generateHash(Class<?> sourceClass) {
        ApplicationHome home = new ApplicationHome(sourceClass);
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            this.update(digest, home.getSource());
            this.update(digest, home.getDir());
            this.update(digest, System.getProperty("user.dir"));
            this.update(digest, System.getProperty("java.home"));
            this.update(digest, System.getProperty("java.class.path"));
            this.update(digest, System.getProperty("sun.java.command"));
            this.update(digest, System.getProperty("sun.boot.class.path"));
            return digest.digest();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void update(MessageDigest digest, Object source) {
        if (source != null) {
            digest.update(this.getUpdateSourceBytes(source));
        }
    }

    private byte[] getUpdateSourceBytes(Object source) {
        if (source instanceof File) {
            return this.getUpdateSourceBytes(((File)source).getAbsolutePath());
        }
        return source.toString().getBytes();
    }

    private String toHexString(byte[] bytes) {
        char[] hex = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            hex[i * 2] = HEX_CHARS[b >>> 4];
            hex[i * 2 + 1] = HEX_CHARS[b & 0xF];
        }
        return new String(hex);
    }
}

