/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.embedded.Compression;
import org.springframework.boot.context.embedded.ConfigurableEmbeddedServletContainer;
import org.springframework.boot.context.embedded.ErrorPage;
import org.springframework.boot.context.embedded.JspServlet;
import org.springframework.boot.context.embedded.MimeMappings;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.Ssl;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractConfigurableEmbeddedServletContainer
implements ConfigurableEmbeddedServletContainer {
    private static final int DEFAULT_SESSION_TIMEOUT = (int)TimeUnit.MINUTES.toSeconds(30L);
    private String contextPath = "";
    private String displayName;
    private boolean registerDefaultServlet = true;
    private int port = 8080;
    private List<ServletContextInitializer> initializers = new ArrayList<ServletContextInitializer>();
    private File documentRoot;
    private Set<ErrorPage> errorPages = new LinkedHashSet<ErrorPage>();
    private MimeMappings mimeMappings = new MimeMappings(MimeMappings.DEFAULT);
    private InetAddress address;
    private int sessionTimeout = DEFAULT_SESSION_TIMEOUT;
    private boolean persistSession;
    private Ssl ssl;
    private JspServlet jspServlet = new JspServlet();
    private Compression compression;

    public AbstractConfigurableEmbeddedServletContainer() {
    }

    public AbstractConfigurableEmbeddedServletContainer(int port) {
        this.port = port;
    }

    public AbstractConfigurableEmbeddedServletContainer(String contextPath, int port) {
        this.checkContextPath(contextPath);
        this.contextPath = contextPath;
        this.port = port;
    }

    @Override
    public void setContextPath(String contextPath) {
        this.checkContextPath(contextPath);
        this.contextPath = contextPath;
    }

    private void checkContextPath(String contextPath) {
        Assert.notNull((Object)contextPath, (String)"ContextPath must not be null");
        if (contextPath.length() > 0) {
            if ("/".equals(contextPath)) {
                throw new IllegalArgumentException("Root ContextPath must be specified using an empty string");
            }
            if (!contextPath.startsWith("/") || contextPath.endsWith("/")) {
                throw new IllegalArgumentException("ContextPath must start with '/' and not end with '/'");
            }
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @Override
    public void setSessionTimeout(int sessionTimeout, TimeUnit timeUnit) {
        Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must not be null");
        this.sessionTimeout = (int)timeUnit.toSeconds(sessionTimeout);
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public void setPersistSession(boolean persistSession) {
        this.persistSession = persistSession;
    }

    public boolean isPersistSession() {
        return this.persistSession;
    }

    @Override
    public void setInitializers(List<? extends ServletContextInitializer> initializers) {
        Assert.notNull(initializers, (String)"Initializers must not be null");
        this.initializers = new ArrayList<ServletContextInitializer>(initializers);
    }

    @Override
    public void addInitializers(ServletContextInitializer ... initializers) {
        Assert.notNull((Object)initializers, (String)"Initializers must not be null");
        this.initializers.addAll(Arrays.asList(initializers));
    }

    @Override
    public void setDocumentRoot(File documentRoot) {
        this.documentRoot = documentRoot;
    }

    public File getDocumentRoot() {
        return this.documentRoot;
    }

    @Override
    public void setErrorPages(Set<ErrorPage> errorPages) {
        Assert.notNull(errorPages, (String)"ErrorPages must not be null");
        this.errorPages = new LinkedHashSet<ErrorPage>(errorPages);
    }

    @Override
    public void addErrorPages(ErrorPage ... errorPages) {
        Assert.notNull((Object)errorPages, (String)"ErrorPages must not be null");
        this.errorPages.addAll(Arrays.asList(errorPages));
    }

    public Set<ErrorPage> getErrorPages() {
        return this.errorPages;
    }

    @Override
    public void setMimeMappings(MimeMappings mimeMappings) {
        this.mimeMappings = new MimeMappings(mimeMappings);
    }

    public MimeMappings getMimeMappings() {
        return this.mimeMappings;
    }

    @Override
    public void setRegisterDefaultServlet(boolean registerDefaultServlet) {
        this.registerDefaultServlet = registerDefaultServlet;
    }

    @Override
    public void setRegisterJspServlet(boolean registerJspServlet) {
        Assert.notNull((Object)this.jspServlet);
        this.jspServlet.setRegistered(registerJspServlet);
    }

    public boolean isRegisterDefaultServlet() {
        return this.registerDefaultServlet;
    }

    @Override
    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    @Override
    public void setJspServletClassName(String jspServletClassName) {
        Assert.notNull((Object)this.jspServlet);
        this.jspServlet.setClassName(jspServletClassName);
    }

    @Override
    public void setJspServlet(JspServlet jspServlet) {
        this.jspServlet = jspServlet;
    }

    public JspServlet getJspServlet() {
        return this.jspServlet;
    }

    public Compression getCompression() {
        return this.compression;
    }

    @Override
    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    protected final ServletContextInitializer[] mergeInitializers(ServletContextInitializer ... initializers) {
        ArrayList<ServletContextInitializer> mergedInitializers = new ArrayList<ServletContextInitializer>();
        mergedInitializers.addAll(Arrays.asList(initializers));
        mergedInitializers.addAll(this.initializers);
        return mergedInitializers.toArray(new ServletContextInitializer[mergedInitializers.size()]);
    }

    protected boolean shouldRegisterJspServlet() {
        return this.jspServlet != null && this.jspServlet.getRegistered() && ClassUtils.isPresent((String)this.jspServlet.getClassName(), (ClassLoader)this.getClass().getClassLoader());
    }
}

