/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetaData;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.ConfigurationPropertiesHolder;
import org.springframework.boot.env.PropertySourcesLoader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

public class ConfigurationPropertiesBindingPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
ResourceLoaderAware,
EnvironmentAware,
ApplicationContextAware,
InitializingBean,
DisposableBean,
PriorityOrdered {
    public static final String VALIDATOR_BEAN_NAME = "configurationPropertiesValidator";
    private static final String[] VALIDATOR_CLASSES = new String[]{"javax.validation.Validator", "javax.validation.ValidatorFactory"};
    private ConfigurationBeanFactoryMetaData beans = new ConfigurationBeanFactoryMetaData();
    private PropertySources propertySources;
    private Validator validator;
    private boolean ownedValidator = false;
    private ConversionService conversionService;
    private DefaultConversionService defaultConversionService;
    private BeanFactory beanFactory;
    private ResourceLoader resourceLoader = new DefaultResourceLoader();
    private Environment environment = new StandardEnvironment();
    private ApplicationContext applicationContext;
    private List<Converter<?, ?>> converters = Collections.emptyList();
    private int order = -2147483647;

    @Autowired(required=false)
    @ConfigurationPropertiesBinding
    public void setConverters(List<Converter<?, ?>> converters) {
        this.converters = converters;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setPropertySources(PropertySources propertySources) {
        this.propertySources = propertySources;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setBeanMetaDataStore(ConfigurationBeanFactoryMetaData beans) {
        this.beans = beans;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.propertySources == null) {
            this.propertySources = this.deducePropertySources();
        }
        if (this.validator == null) {
            this.validator = this.getOptionalBean(VALIDATOR_BEAN_NAME, Validator.class);
            if (this.validator == null && this.isJsr303Present()) {
                this.validator = new Jsr303ValidatorFactory().run(this.applicationContext);
                this.ownedValidator = true;
            }
        }
        if (this.conversionService == null) {
            this.conversionService = this.getOptionalBean("conversionService", ConversionService.class);
        }
    }

    private boolean isJsr303Present() {
        for (String validatorClass : VALIDATOR_CLASSES) {
            if (ClassUtils.isPresent((String)validatorClass, (ClassLoader)this.applicationContext.getClassLoader())) continue;
            return false;
        }
        return true;
    }

    public void destroy() throws Exception {
        if (this.ownedValidator) {
            ((DisposableBean)this.validator).destroy();
        }
    }

    private PropertySources deducePropertySources() {
        PropertySourcesPlaceholderConfigurer configurer = this.getSinglePropertySourcesPlaceholderConfigurer();
        if (configurer != null) {
            return new FlatPropertySources(configurer.getAppliedPropertySources());
        }
        if (this.environment instanceof ConfigurableEnvironment) {
            MutablePropertySources propertySources = ((ConfigurableEnvironment)this.environment).getPropertySources();
            return new FlatPropertySources((PropertySources)propertySources);
        }
        return new MutablePropertySources();
    }

    private PropertySourcesPlaceholderConfigurer getSinglePropertySourcesPlaceholderConfigurer() {
        ListableBeanFactory listableBeanFactory;
        Map beans;
        if (this.beanFactory instanceof ListableBeanFactory && (beans = (listableBeanFactory = (ListableBeanFactory)this.beanFactory).getBeansOfType(PropertySourcesPlaceholderConfigurer.class, false, false)).size() == 1) {
            return (PropertySourcesPlaceholderConfigurer)beans.values().iterator().next();
        }
        return null;
    }

    private <T> T getOptionalBean(String name, Class<T> type) {
        try {
            return (T)this.beanFactory.getBean(name, type);
        }
        catch (NoSuchBeanDefinitionException ex) {
            return null;
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ConfigurationProperties annotation = (ConfigurationProperties)AnnotationUtils.findAnnotation(bean.getClass(), ConfigurationProperties.class);
        if (annotation != null || bean instanceof ConfigurationPropertiesHolder) {
            this.postProcessBeforeInitialization(bean, beanName, annotation);
        }
        if ((annotation = this.beans.findFactoryAnnotation(beanName, ConfigurationProperties.class)) != null) {
            this.postProcessBeforeInitialization(bean, beanName, annotation);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private void postProcessBeforeInitialization(Object bean, String beanName, ConfigurationProperties annotation) {
        Object target = bean instanceof ConfigurationPropertiesHolder ? ((ConfigurationPropertiesHolder)bean).getTarget() : bean;
        PropertiesConfigurationFactory<Object> factory = new PropertiesConfigurationFactory<Object>(target);
        if (annotation != null && annotation.locations().length != 0) {
            factory.setPropertySources(this.loadPropertySources(annotation.locations(), annotation.merge()));
        } else {
            factory.setPropertySources(this.propertySources);
        }
        factory.setValidator(this.determineValidator(bean));
        factory.setConversionService(this.conversionService == null ? this.getDefaultConversionService() : this.conversionService);
        if (annotation != null) {
            String targetName;
            factory.setIgnoreInvalidFields(annotation.ignoreInvalidFields());
            factory.setIgnoreUnknownFields(annotation.ignoreUnknownFields());
            factory.setExceptionIfInvalid(annotation.exceptionIfInvalid());
            factory.setIgnoreNestedProperties(annotation.ignoreNestedProperties());
            String string = targetName = StringUtils.hasLength((String)annotation.value()) ? annotation.value() : annotation.prefix();
            if (StringUtils.hasLength((String)targetName)) {
                factory.setTargetName(targetName);
            }
        }
        try {
            factory.bindPropertiesToTarget();
        }
        catch (Exception ex) {
            String targetClass = ClassUtils.getShortName(target.getClass());
            throw new BeanCreationException(beanName, "Could not bind properties to " + targetClass + " (" + this.getAnnotationDetails(annotation) + ")", (Throwable)ex);
        }
    }

    private String getAnnotationDetails(ConfigurationProperties annotation) {
        if (annotation == null) {
            return "";
        }
        StringBuilder details = new StringBuilder();
        details.append("prefix=").append(StringUtils.hasLength((String)annotation.value()) ? annotation.value() : annotation.prefix());
        details.append(", ignoreInvalidFields=").append(annotation.ignoreInvalidFields());
        details.append(", ignoreUnknownFields=").append(annotation.ignoreUnknownFields());
        details.append(", ignoreNestedProperties=").append(annotation.ignoreNestedProperties());
        return details.toString();
    }

    private Validator determineValidator(Object bean) {
        boolean globalValidatorSupportBean;
        boolean bl = globalValidatorSupportBean = this.validator != null && this.validator.supports(bean.getClass());
        if (ClassUtils.isAssignable(Validator.class, bean.getClass())) {
            if (!globalValidatorSupportBean) {
                return (Validator)bean;
            }
            return new ChainingValidator(this.validator, (Validator)bean);
        }
        return globalValidatorSupportBean ? this.validator : null;
    }

    private PropertySources loadPropertySources(String[] locations, boolean mergeDefaultSources) {
        try {
            PropertySourcesLoader loader = new PropertySourcesLoader();
            for (String location : locations) {
                Resource resource = this.resourceLoader.getResource(this.environment.resolvePlaceholders(location));
                String[] profiles = this.environment.getActiveProfiles();
                int i = profiles.length;
                while (i-- > 0) {
                    String profile = profiles[i];
                    loader.load(resource, profile);
                }
                loader.load(resource);
            }
            MutablePropertySources loaded = loader.getPropertySources();
            if (mergeDefaultSources) {
                for (PropertySource propertySource : this.propertySources) {
                    loaded.addLast(propertySource);
                }
            }
            return loaded;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private ConversionService getDefaultConversionService() {
        if (this.defaultConversionService == null) {
            DefaultConversionService conversionService = new DefaultConversionService();
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)this);
            for (Converter<?, ?> converter : this.converters) {
                conversionService.addConverter(converter);
            }
            this.defaultConversionService = conversionService;
        }
        return this.defaultConversionService;
    }

    private static class FlatPropertySources
    implements PropertySources {
        private PropertySources propertySources;

        public FlatPropertySources(PropertySources propertySources) {
            this.propertySources = propertySources;
        }

        public Iterator<PropertySource<?>> iterator() {
            MutablePropertySources result = this.getFlattened();
            return result.iterator();
        }

        public boolean contains(String name) {
            return this.get(name) != null;
        }

        public PropertySource<?> get(String name) {
            return this.getFlattened().get(name);
        }

        private MutablePropertySources getFlattened() {
            MutablePropertySources result = new MutablePropertySources();
            for (PropertySource propertySource : this.propertySources) {
                this.flattenPropertySources(propertySource, result);
            }
            return result;
        }

        private void flattenPropertySources(PropertySource<?> propertySource, MutablePropertySources result) {
            Object source = propertySource.getSource();
            if (source instanceof ConfigurableEnvironment) {
                ConfigurableEnvironment environment = (ConfigurableEnvironment)source;
                for (PropertySource childSource : environment.getPropertySources()) {
                    this.flattenPropertySources(childSource, result);
                }
            } else {
                result.addLast(propertySource);
            }
        }
    }

    private static class ChainingValidator
    implements Validator {
        private Validator[] validators;

        public ChainingValidator(Validator ... validators) {
            Assert.notNull((Object)validators, (String)"Validators must not be null");
            this.validators = validators;
        }

        public boolean supports(Class<?> clazz) {
            for (Validator validator : this.validators) {
                if (!validator.supports(clazz)) continue;
                return true;
            }
            return false;
        }

        public void validate(Object target, Errors errors) {
            for (Validator validator : this.validators) {
                if (!validator.supports(target.getClass())) continue;
                validator.validate(target, errors);
            }
        }
    }

    private static class Jsr303ValidatorFactory {
        private Jsr303ValidatorFactory() {
        }

        public Validator run(ApplicationContext applicationContext) {
            LocalValidatorFactoryBean validator = new LocalValidatorFactoryBean();
            validator.setApplicationContext(applicationContext);
            validator.afterPropertiesSet();
            return validator;
        }
    }
}

