/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.scan;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.context.scan.AbstractEntityScanBeanPostProcessor;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractEntityScanRegistrar
implements ImportBeanDefinitionRegistrar {
    private final Class<? extends Annotation> annotationType;
    private final String beanPostProcessorName;
    private final Class<? extends AbstractEntityScanBeanPostProcessor> beanPostProcessorType;

    protected AbstractEntityScanRegistrar(Class<? extends Annotation> annotationType, String beanPostProcessorName, Class<? extends AbstractEntityScanBeanPostProcessor> beanPostProcessorType) {
        this.beanPostProcessorName = beanPostProcessorName;
        this.annotationType = annotationType;
        this.beanPostProcessorType = beanPostProcessorType;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Set<String> packagesToScan = this.getPackagesToScan(importingClassMetadata);
        if (!registry.containsBeanDefinition(this.beanPostProcessorName)) {
            this.addEntityScanBeanPostProcessor(registry, packagesToScan);
        } else {
            this.updateEntityScanBeanPostProcessor(registry, packagesToScan);
        }
    }

    protected Set<String> getPackagesToScan(AnnotationMetadata metadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(this.annotationType.getName()));
        Object[] value = attributes.getStringArray("value");
        Object[] basePackages = attributes.getStringArray("basePackages");
        Class[] basePackageClasses = attributes.getClassArray("basePackageClasses");
        if (!ObjectUtils.isEmpty((Object[])value)) {
            Assert.state((boolean)ObjectUtils.isEmpty((Object[])basePackages), (String)String.format("@%s basePackages and value attributes are mutually exclusive", this.annotationType.getSimpleName()));
        }
        LinkedHashSet<String> packagesToScan = new LinkedHashSet<String>();
        packagesToScan.addAll(Arrays.asList(value));
        packagesToScan.addAll(Arrays.asList(basePackages));
        for (Class basePackageClass : basePackageClasses) {
            packagesToScan.add(ClassUtils.getPackageName((Class)basePackageClass));
        }
        if (packagesToScan.isEmpty()) {
            return Collections.singleton(ClassUtils.getPackageName((String)metadata.getClassName()));
        }
        return packagesToScan;
    }

    private void addEntityScanBeanPostProcessor(BeanDefinitionRegistry registry, Set<String> packagesToScan) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(this.beanPostProcessorType);
        beanDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)this.toArray(packagesToScan));
        beanDefinition.setRole(2);
        beanDefinition.setSynthetic(true);
        registry.registerBeanDefinition(this.beanPostProcessorName, (BeanDefinition)beanDefinition);
    }

    private void updateEntityScanBeanPostProcessor(BeanDefinitionRegistry registry, Set<String> packagesToScan) {
        BeanDefinition definition = registry.getBeanDefinition(this.beanPostProcessorName);
        ConstructorArgumentValues.ValueHolder constructorArguments = definition.getConstructorArgumentValues().getGenericArgumentValue(String[].class);
        LinkedHashSet<String> mergedPackages = new LinkedHashSet<String>();
        mergedPackages.addAll(Arrays.asList((String[])constructorArguments.getValue()));
        mergedPackages.addAll(packagesToScan);
        constructorArguments.setValue((Object)this.toArray(mergedPackages));
    }

    private String[] toArray(Set<String> set) {
        return set.toArray(new String[set.size()]);
    }
}

