/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.springframework.boot.json.JsonParser;

public class JacksonJsonParser
implements JsonParser {
    @Override
    public Map<String, Object> parseMap(String json) {
        try {
            return (Map)new ObjectMapper().readValue(json, (TypeReference)new MapTypeReference());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot parse JSON", ex);
        }
    }

    @Override
    public List<Object> parseList(String json) {
        try {
            TypeReference<List<Object>> type = new TypeReference<List<Object>>(){};
            return (List)new ObjectMapper().readValue(json, (TypeReference)type);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot parse JSON", ex);
        }
    }

    private static class MapTypeReference
    extends TypeReference<Map<String, Object>> {
        private MapTypeReference() {
        }
    }
}

