/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.boot.web.client.RootUriTemplateHandler;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthorizationInterceptor;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplateHandler;

public class RestTemplateBuilder {
    private static final Map<String, String> REQUEST_FACTORY_CANDIDATES;
    private final boolean detectRequestFactory;
    private final String rootUri;
    private final Set<HttpMessageConverter<?>> messageConverters;
    private final ClientHttpRequestFactory requestFactory;
    private final UriTemplateHandler uriTemplateHandler;
    private final ResponseErrorHandler errorHandler;
    private final BasicAuthorizationInterceptor basicAuthorization;
    private final Set<RestTemplateCustomizer> customizers;

    public RestTemplateBuilder(RestTemplateCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"Customizers must not be null");
        this.detectRequestFactory = true;
        this.rootUri = null;
        this.messageConverters = null;
        this.requestFactory = null;
        this.uriTemplateHandler = null;
        this.errorHandler = null;
        this.basicAuthorization = null;
        this.customizers = Collections.unmodifiableSet(new LinkedHashSet<RestTemplateCustomizer>(Arrays.asList(customizers)));
    }

    private RestTemplateBuilder(boolean detectRequestFactory, String rootUri, Set<HttpMessageConverter<?>> messageConverters, ClientHttpRequestFactory requestFactory, UriTemplateHandler uriTemplateHandler, ResponseErrorHandler errorHandler, BasicAuthorizationInterceptor basicAuthorization, Set<RestTemplateCustomizer> customizers) {
        this.detectRequestFactory = detectRequestFactory;
        this.rootUri = rootUri;
        this.messageConverters = messageConverters;
        this.requestFactory = requestFactory;
        this.uriTemplateHandler = uriTemplateHandler;
        this.errorHandler = errorHandler;
        this.basicAuthorization = basicAuthorization;
        this.customizers = customizers;
    }

    public RestTemplateBuilder detectRequestFactory(boolean detectRequestFactory) {
        return new RestTemplateBuilder(detectRequestFactory, this.rootUri, this.messageConverters, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthorization, this.customizers);
    }

    public RestTemplateBuilder rootUri(String rootUri) {
        return new RestTemplateBuilder(this.detectRequestFactory, rootUri, this.messageConverters, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthorization, this.customizers);
    }

    public RestTemplateBuilder messageConverters(HttpMessageConverter<?> ... messageConverters) {
        Assert.notNull(messageConverters, (String)"MessageConverters must not be null");
        return this.messageConverters(Arrays.asList(messageConverters));
    }

    public RestTemplateBuilder messageConverters(Collection<? extends HttpMessageConverter<?>> messageConverters) {
        Assert.notNull(messageConverters, (String)"MessageConverters must not be null");
        return new RestTemplateBuilder(this.detectRequestFactory, this.rootUri, Collections.unmodifiableSet(new LinkedHashSet(messageConverters)), this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthorization, this.customizers);
    }

    public RestTemplateBuilder additionalMessageConverters(HttpMessageConverter<?> ... messageConverters) {
        Assert.notNull(messageConverters, (String)"MessageConverters must not be null");
        return this.additionalMessageConverters(Arrays.asList(messageConverters));
    }

    public RestTemplateBuilder additionalMessageConverters(Collection<? extends HttpMessageConverter<?>> messageConverters) {
        Assert.notNull(messageConverters, (String)"MessageConverters must not be null");
        return new RestTemplateBuilder(this.detectRequestFactory, this.rootUri, this.append(this.messageConverters, messageConverters), this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthorization, this.customizers);
    }

    public RestTemplateBuilder defaultMessageConverters() {
        return new RestTemplateBuilder(this.detectRequestFactory, this.rootUri, Collections.unmodifiableSet(new LinkedHashSet(new RestTemplate().getMessageConverters())), this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthorization, this.customizers);
    }

    public RestTemplateBuilder requestFactory(Class<? extends ClientHttpRequestFactory> requestFactory) {
        Assert.notNull(requestFactory, (String)"RequestFactory must not be null");
        return this.requestFactory((ClientHttpRequestFactory)BeanUtils.instantiate(requestFactory));
    }

    public RestTemplateBuilder requestFactory(ClientHttpRequestFactory requestFactory) {
        Assert.notNull((Object)requestFactory, (String)"RequestFactory must not be null");
        return new RestTemplateBuilder(this.detectRequestFactory, this.rootUri, this.messageConverters, requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthorization, this.customizers);
    }

    public RestTemplateBuilder uriTemplateHandler(UriTemplateHandler uriTemplateHandler) {
        Assert.notNull((Object)uriTemplateHandler, (String)"UriTemplateHandler must not be null");
        return new RestTemplateBuilder(this.detectRequestFactory, this.rootUri, this.messageConverters, this.requestFactory, uriTemplateHandler, this.errorHandler, this.basicAuthorization, this.customizers);
    }

    public RestTemplateBuilder errorHandler(ResponseErrorHandler errorHandler) {
        Assert.notNull((Object)errorHandler, (String)"ErrorHandler must not be null");
        return new RestTemplateBuilder(this.detectRequestFactory, this.rootUri, this.messageConverters, this.requestFactory, this.uriTemplateHandler, errorHandler, this.basicAuthorization, this.customizers);
    }

    public RestTemplateBuilder basicAuthorization(String username, String password) {
        return new RestTemplateBuilder(this.detectRequestFactory, this.rootUri, this.messageConverters, this.requestFactory, this.uriTemplateHandler, this.errorHandler, new BasicAuthorizationInterceptor(username, password), this.customizers);
    }

    public RestTemplateBuilder customizers(RestTemplateCustomizer ... restTemplateCustomizers) {
        Assert.notNull((Object)restTemplateCustomizers, (String)"RestTemplateCustomizers must not be null");
        return this.customizers(Arrays.asList(restTemplateCustomizers));
    }

    public RestTemplateBuilder customizers(Collection<? extends RestTemplateCustomizer> restTemplateCustomizers) {
        Assert.notNull(restTemplateCustomizers, (String)"RestTemplateCustomizers must not be null");
        return new RestTemplateBuilder(this.detectRequestFactory, this.rootUri, this.messageConverters, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthorization, Collections.unmodifiableSet(new LinkedHashSet<RestTemplateCustomizer>(restTemplateCustomizers)));
    }

    public RestTemplateBuilder additionalCustomizers(RestTemplateCustomizer ... restTemplateCustomizers) {
        Assert.notNull((Object)restTemplateCustomizers, (String)"RestTemplateCustomizers must not be null");
        return this.additionalCustomizers(Arrays.asList(restTemplateCustomizers));
    }

    public RestTemplateBuilder additionalCustomizers(Collection<? extends RestTemplateCustomizer> customizers) {
        Assert.notNull(customizers, (String)"RestTemplateCustomizers must not be null");
        return new RestTemplateBuilder(this.detectRequestFactory, this.rootUri, this.messageConverters, this.requestFactory, this.uriTemplateHandler, this.errorHandler, this.basicAuthorization, this.append(this.customizers, customizers));
    }

    public RestTemplate build() {
        return this.build(RestTemplate.class);
    }

    public <T extends RestTemplate> T build(Class<T> restTemplateClass) {
        return (T)this.configure((RestTemplate)BeanUtils.instantiate(restTemplateClass));
    }

    public <T extends RestTemplate> T configure(T restTemplate) {
        if (this.requestFactory != null) {
            restTemplate.setRequestFactory(this.requestFactory);
        } else if (this.detectRequestFactory) {
            restTemplate.setRequestFactory(this.detectRequestFactory());
        }
        if (!CollectionUtils.isEmpty(this.messageConverters)) {
            restTemplate.setMessageConverters(new ArrayList(this.messageConverters));
        }
        if (this.uriTemplateHandler != null) {
            restTemplate.setUriTemplateHandler(this.uriTemplateHandler);
        }
        if (this.errorHandler != null) {
            restTemplate.setErrorHandler(this.errorHandler);
        }
        if (this.rootUri != null) {
            RootUriTemplateHandler.addTo(restTemplate, this.rootUri);
        }
        if (this.basicAuthorization != null) {
            restTemplate.getInterceptors().add(this.basicAuthorization);
        }
        if (!CollectionUtils.isEmpty(this.customizers)) {
            for (RestTemplateCustomizer customizer : this.customizers) {
                customizer.customize(restTemplate);
            }
        }
        return restTemplate;
    }

    private ClientHttpRequestFactory detectRequestFactory() {
        for (Map.Entry<String, String> candidate : REQUEST_FACTORY_CANDIDATES.entrySet()) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (!ClassUtils.isPresent((String)candidate.getKey(), (ClassLoader)classLoader)) continue;
            Class factoryClass = ClassUtils.resolveClassName((String)candidate.getValue(), (ClassLoader)classLoader);
            return (ClientHttpRequestFactory)BeanUtils.instantiate((Class)factoryClass);
        }
        return new SimpleClientHttpRequestFactory();
    }

    private <T> Set<T> append(Set<T> set, Collection<? extends T> additions) {
        LinkedHashSet result = new LinkedHashSet(set == null ? Collections.emptySet() : set);
        result.addAll(additions);
        return Collections.unmodifiableSet(result);
    }

    static {
        LinkedHashMap<String, String> candidates = new LinkedHashMap<String, String>();
        candidates.put("org.apache.http.client.HttpClient", "org.springframework.http.client.HttpComponentsClientHttpRequestFactory");
        candidates.put("okhttp3.OkHttpClient", "org.springframework.http.client.OkHttp3ClientHttpRequestFactory");
        candidates.put("com.squareup.okhttp.OkHttpClient", "org.springframework.http.client.OkHttpClientHttpRequestFactory");
        candidates.put("io.netty.channel.EventLoopGroup", "org.springframework.http.client.Netty4ClientHttpRequestFactory");
        REQUEST_FACTORY_CANDIDATES = Collections.unmodifiableMap(candidates);
    }
}

