/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.io.IOException;
import java.util.Map;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.env.OriginTrackedYamlLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;

public class YamlPropertySourceLoader
implements PropertySourceLoader {
    @Override
    public String[] getFileExtensions() {
        return new String[]{"yml", "yaml"};
    }

    @Override
    public PropertySource<?> load(String name, Resource resource, String profile) throws IOException {
        if (!ClassUtils.isPresent((String)"org.yaml.snakeyaml.Yaml", null)) {
            throw new IllegalStateException("Attempted to load " + name + " but snakeyaml was not found on the classpath");
        }
        Map<String, Object> source = new OriginTrackedYamlLoader(resource, profile).load();
        if (!source.isEmpty()) {
            return new OriginTrackedMapPropertySource(name, source);
        }
        return null;
    }
}

