/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.util.Map;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.core.env.SystemEnvironmentPropertySource;

public class OriginTrackedSystemPropertySource
extends SystemEnvironmentPropertySource
implements OriginLookup<String> {
    public OriginTrackedSystemPropertySource(String name, Map<String, Object> source) {
        super(name, source);
    }

    public Object getProperty(String name) {
        Object value = super.getProperty(name);
        if (value instanceof OriginTrackedValue) {
            return ((OriginTrackedValue)value).getValue();
        }
        return value;
    }

    @Override
    public Origin getOrigin(String key) {
        Object value = super.getProperty(key);
        if (value instanceof OriginTrackedValue) {
            return ((OriginTrackedValue)value).getOrigin();
        }
        return null;
    }
}

