/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.OriginTrackedSystemPropertySource;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.boot.origin.SystemEnvironmentOrigin;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public class SystemEnvironmentPropertySourceEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final int DEFAULT_ORDER = -2147483644;
    private int order = -2147483644;

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String sourceName = "systemEnvironment";
        PropertySource propertySource = environment.getPropertySources().get(sourceName);
        if (propertySource != null) {
            this.replacePropertySource(environment, sourceName, propertySource);
        }
    }

    private void replacePropertySource(ConfigurableEnvironment environment, String sourceName, PropertySource<?> propertySource) {
        if (propertySource.getSource() instanceof Map) {
            Map originalSource = (Map)propertySource.getSource();
            LinkedHashMap originTrackedSource = new LinkedHashMap(originalSource);
            originTrackedSource.entrySet().forEach(e -> e.setValue(OriginTrackedValue.of(e.getValue(), new SystemEnvironmentOrigin((String)e.getKey()))));
            OriginTrackedSystemPropertySource source = new OriginTrackedSystemPropertySource(sourceName, Collections.unmodifiableMap(originTrackedSource));
            environment.getPropertySources().replace(sourceName, (PropertySource)source);
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

