/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.OrderComparator;
import org.springframework.util.Assert;

public abstract class Configurations {
    private static final Comparator<Object> COMPARATOR = OrderComparator.INSTANCE.thenComparing(other -> other.getClass().getName());
    private Set<Class<?>> classes;

    protected Configurations(Collection<Class<?>> classes) {
        Assert.notNull(classes, (String)"Classes must not be null");
        Collection<Class<?>> sorted = this.sort(classes);
        this.classes = Collections.unmodifiableSet(new LinkedHashSet(sorted));
    }

    protected Collection<Class<?>> sort(Collection<Class<?>> classes) {
        return classes;
    }

    protected final Set<Class<?>> getClasses() {
        return this.classes;
    }

    protected Configurations merge(Configurations other) {
        LinkedHashSet mergedClasses = new LinkedHashSet(this.getClasses());
        mergedClasses.addAll(other.getClasses());
        return this.merge(mergedClasses);
    }

    protected abstract Configurations merge(Set<Class<?>> var1);

    public static Class<?>[] getClasses(Configurations ... configurations) {
        return Configurations.getClasses(Arrays.asList(configurations));
    }

    public static Class<?>[] getClasses(Collection<Configurations> configurations) {
        ArrayList<Configurations> orderedConfigurations = new ArrayList<Configurations>(configurations);
        orderedConfigurations.sort(COMPARATOR);
        List<Configurations> collated = Configurations.collate(orderedConfigurations);
        return collated.stream().flatMap(c -> c.getClasses().stream()).collect(Collectors.toCollection(LinkedHashSet::new)).toArray(new Class[0]);
    }

    private static List<Configurations> collate(List<Configurations> orderedConfigurations) {
        LinkedList<Configurations> collated = new LinkedList<Configurations>();
        for (Configurations item : orderedConfigurations) {
            if (collated.isEmpty() || collated.getLast().getClass() != item.getClass()) {
                collated.add(item);
                continue;
            }
            collated.set(collated.size() - 1, collated.getLast().merge(item));
        }
        return collated;
    }
}

