/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.boot.context.properties.source.IterableConfigurationPropertySource;
import org.springframework.boot.context.properties.source.PropertyMapper;
import org.springframework.boot.context.properties.source.PropertyMapping;
import org.springframework.boot.context.properties.source.SpringConfigurationPropertySource;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ObjectUtils;

class SpringIterableConfigurationPropertySource
extends SpringConfigurationPropertySource
implements IterableConfigurationPropertySource {
    private volatile Object cacheKey;
    private volatile Cache cache;

    SpringIterableConfigurationPropertySource(EnumerablePropertySource<?> propertySource, PropertyMapper mapper) {
        super((PropertySource<?>)propertySource, mapper, null);
        this.assertEnumerablePropertySource(propertySource);
    }

    private void assertEnumerablePropertySource(EnumerablePropertySource<?> propertySource) {
        if (this.getPropertySource() instanceof MapPropertySource) {
            try {
                ((Map)((MapPropertySource)this.getPropertySource()).getSource()).size();
            }
            catch (UnsupportedOperationException ex) {
                throw new IllegalArgumentException("PropertySource must be fully enumerable");
            }
        }
    }

    @Override
    public ConfigurationProperty getConfigurationProperty(ConfigurationPropertyName name) {
        ConfigurationProperty configurationProperty = super.getConfigurationProperty(name);
        if (configurationProperty == null) {
            configurationProperty = this.find(this.getPropertyMappings(), name);
        }
        return configurationProperty;
    }

    @Override
    public Stream<ConfigurationPropertyName> stream() {
        return this.getConfigurationPropertyNames().stream();
    }

    @Override
    public Iterator<ConfigurationPropertyName> iterator() {
        return this.getConfigurationPropertyNames().iterator();
    }

    @Override
    public ConfigurationPropertyState containsDescendantOf(ConfigurationPropertyName name) {
        return ConfigurationPropertyState.search(this, name::isAncestorOf);
    }

    private List<ConfigurationPropertyName> getConfigurationPropertyNames() {
        List<ConfigurationPropertyName> names;
        Cache cache = this.getCache();
        List<ConfigurationPropertyName> list = names = cache != null ? cache.getNames() : null;
        if (names != null) {
            return names;
        }
        List<PropertyMapping> mappings = this.getPropertyMappings();
        names = new ArrayList<ConfigurationPropertyName>(mappings.size());
        for (PropertyMapping mapping : mappings) {
            names.add(mapping.getConfigurationPropertyName());
        }
        names = Collections.unmodifiableList(names);
        if (cache != null) {
            cache.setNames(names);
        }
        return names;
    }

    private List<PropertyMapping> getPropertyMappings() {
        List<PropertyMapping> mappings;
        Cache cache = this.getCache();
        List<PropertyMapping> list = mappings = cache != null ? cache.getMappings() : null;
        if (mappings != null) {
            return mappings;
        }
        String[] names = this.getPropertySource().getPropertyNames();
        mappings = new ArrayList<PropertyMapping>(names.length);
        for (String name : names) {
            mappings.addAll(this.getMapper().map((PropertySource<?>)this.getPropertySource(), name));
        }
        mappings = Collections.unmodifiableList(mappings);
        if (cache != null) {
            cache.setMappings(mappings);
        }
        return mappings;
    }

    private Cache getCache() {
        Object cacheKey = this.getCacheKey();
        if (cacheKey == null) {
            return null;
        }
        if (ObjectUtils.nullSafeEquals((Object)cacheKey, (Object)this.cacheKey)) {
            return this.cache;
        }
        this.cache = new Cache();
        this.cacheKey = cacheKey;
        return this.cache;
    }

    private Object getCacheKey() {
        if (this.getPropertySource() instanceof MapPropertySource) {
            return ((Map)((MapPropertySource)this.getPropertySource()).getSource()).keySet();
        }
        return this.getPropertySource().getPropertyNames();
    }

    protected EnumerablePropertySource<?> getPropertySource() {
        return (EnumerablePropertySource)super.getPropertySource();
    }

    private static class Cache {
        private List<ConfigurationPropertyName> names;
        private List<PropertyMapping> mappings;

        private Cache() {
        }

        public List<ConfigurationPropertyName> getNames() {
            return this.names;
        }

        public void setNames(List<ConfigurationPropertyName> names) {
            this.names = names;
        }

        public List<PropertyMapping> getMappings() {
            return this.mappings;
        }

        public void setMappings(List<PropertyMapping> mappings) {
            this.mappings = mappings;
        }
    }
}

