/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet.server;

import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.web.server.AbstractConfigurableWebServerFactory;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.boot.web.servlet.server.DocumentRoot;
import org.springframework.boot.web.servlet.server.Jsp;
import org.springframework.boot.web.servlet.server.SessionStoreDirectory;
import org.springframework.boot.web.servlet.server.StaticResourceJars;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractServletWebServerFactory
extends AbstractConfigurableWebServerFactory
implements ConfigurableServletWebServerFactory {
    private static final int DEFAULT_SESSION_TIMEOUT = (int)TimeUnit.MINUTES.toSeconds(30L);
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String contextPath = "";
    private String displayName;
    private int sessionTimeout = DEFAULT_SESSION_TIMEOUT;
    private boolean persistSession;
    private boolean registerDefaultServlet = true;
    private MimeMappings mimeMappings = new MimeMappings(MimeMappings.DEFAULT);
    private List<ServletContextInitializer> initializers = new ArrayList<ServletContextInitializer>();
    private Jsp jsp = new Jsp();
    private Map<Locale, Charset> localeCharsetMappings = new HashMap<Locale, Charset>();
    private final SessionStoreDirectory sessionStoreDir = new SessionStoreDirectory();
    private final DocumentRoot documentRoot = new DocumentRoot(this.logger);
    private final StaticResourceJars staticResourceJars = new StaticResourceJars();

    public AbstractServletWebServerFactory() {
    }

    public AbstractServletWebServerFactory(int port) {
        super(port);
    }

    public AbstractServletWebServerFactory(String contextPath, int port) {
        super(port);
        this.checkContextPath(contextPath);
        this.contextPath = contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public void setContextPath(String contextPath) {
        this.checkContextPath(contextPath);
        this.contextPath = contextPath;
    }

    private void checkContextPath(String contextPath) {
        Assert.notNull((Object)contextPath, (String)"ContextPath must not be null");
        if (!contextPath.isEmpty()) {
            if ("/".equals(contextPath)) {
                throw new IllegalArgumentException("Root ContextPath must be specified using an empty string");
            }
            if (!contextPath.startsWith("/") || contextPath.endsWith("/")) {
                throw new IllegalArgumentException("ContextPath must start with '/' and not end with '/'");
            }
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @Override
    public void setSessionTimeout(int sessionTimeout, TimeUnit timeUnit) {
        Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must not be null");
        this.sessionTimeout = (int)timeUnit.toSeconds(sessionTimeout);
    }

    public boolean isPersistSession() {
        return this.persistSession;
    }

    @Override
    public void setPersistSession(boolean persistSession) {
        this.persistSession = persistSession;
    }

    public File getSessionStoreDir() {
        return this.sessionStoreDir.getDirectory();
    }

    @Override
    public void setSessionStoreDir(File sessionStoreDir) {
        this.sessionStoreDir.setDirectory(sessionStoreDir);
    }

    public boolean isRegisterDefaultServlet() {
        return this.registerDefaultServlet;
    }

    @Override
    public void setRegisterDefaultServlet(boolean registerDefaultServlet) {
        this.registerDefaultServlet = registerDefaultServlet;
    }

    public MimeMappings getMimeMappings() {
        return this.mimeMappings;
    }

    @Override
    public void setMimeMappings(MimeMappings mimeMappings) {
        this.mimeMappings = new MimeMappings(mimeMappings);
    }

    public File getDocumentRoot() {
        return this.documentRoot.getDirectory();
    }

    @Override
    public void setDocumentRoot(File documentRoot) {
        this.documentRoot.setDirectory(documentRoot);
    }

    @Override
    public void setInitializers(List<? extends ServletContextInitializer> initializers) {
        Assert.notNull(initializers, (String)"Initializers must not be null");
        this.initializers = new ArrayList<ServletContextInitializer>(initializers);
    }

    @Override
    public void addInitializers(ServletContextInitializer ... initializers) {
        Assert.notNull((Object)initializers, (String)"Initializers must not be null");
        this.initializers.addAll(Arrays.asList(initializers));
    }

    public Jsp getJsp() {
        return this.jsp;
    }

    @Override
    public void setJsp(Jsp jsp) {
        this.jsp = jsp;
    }

    public Map<Locale, Charset> getLocaleCharsetMappings() {
        return this.localeCharsetMappings;
    }

    @Override
    public void setLocaleCharsetMappings(Map<Locale, Charset> localeCharsetMappings) {
        Assert.notNull(localeCharsetMappings, (String)"localeCharsetMappings must not be null");
        this.localeCharsetMappings = localeCharsetMappings;
    }

    protected final ServletContextInitializer[] mergeInitializers(ServletContextInitializer ... initializers) {
        ArrayList<ServletContextInitializer> mergedInitializers = new ArrayList<ServletContextInitializer>();
        mergedInitializers.addAll(Arrays.asList(initializers));
        mergedInitializers.addAll(this.initializers);
        return mergedInitializers.toArray(new ServletContextInitializer[mergedInitializers.size()]);
    }

    protected boolean shouldRegisterJspServlet() {
        return this.jsp != null && this.jsp.getRegistered() && ClassUtils.isPresent((String)this.jsp.getClassName(), (ClassLoader)this.getClass().getClassLoader());
    }

    protected final File getValidDocumentRoot() {
        return this.documentRoot.getValidDirectory();
    }

    protected final List<URL> getUrlsOfJarsWithMetaInfResources() {
        return this.staticResourceJars.getUrls();
    }

    protected final File getValidSessionStoreDir() {
        return this.sessionStoreDir.getValidDirectory(true);
    }

    protected final File getValidSessionStoreDir(boolean mkdirs) {
        return this.sessionStoreDir.getValidDirectory(mkdirs);
    }
}

