/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.context.properties.CompositePropertySources;
import org.springframework.boot.context.properties.ConfigurationBeanFactoryMetaData;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinder;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinderBuilder;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindingException;
import org.springframework.boot.context.properties.FilteredPropertySources;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.StandardEnvironment;

public class ConfigurationPropertiesBindingPostProcessor
implements BeanPostProcessor,
BeanFactoryAware,
EnvironmentAware,
ApplicationContextAware,
InitializingBean,
PriorityOrdered {
    private static final Log logger = LogFactory.getLog(ConfigurationPropertiesBindingPostProcessor.class);
    private ConfigurationBeanFactoryMetaData beans = new ConfigurationBeanFactoryMetaData();
    private BeanFactory beanFactory;
    private Environment environment = new StandardEnvironment();
    private ApplicationContext applicationContext;
    private ConfigurationPropertiesBinder configurationPropertiesBinder;
    private PropertySources propertySources;

    public int getOrder() {
        return -2147483647;
    }

    public void setBeanMetaDataStore(ConfigurationBeanFactoryMetaData beans) {
        this.beans = beans;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        this.propertySources = this.deducePropertySources();
    }

    private PropertySources deducePropertySources() {
        MutablePropertySources environmentPropertySources = this.extractEnvironmentPropertySources();
        PropertySourcesPlaceholderConfigurer configurer = this.getSinglePropertySourcesPlaceholderConfigurer();
        if (configurer == null) {
            if (environmentPropertySources != null) {
                return environmentPropertySources;
            }
            throw new IllegalStateException("Unable to obtain PropertySources from PropertySourcesPlaceholderConfigurer or Environment");
        }
        PropertySources appliedPropertySources = configurer.getAppliedPropertySources();
        if (environmentPropertySources == null) {
            return appliedPropertySources;
        }
        return new CompositePropertySources(new PropertySources[]{new FilteredPropertySources(appliedPropertySources, "environmentProperties"), environmentPropertySources});
    }

    private MutablePropertySources extractEnvironmentPropertySources() {
        if (this.environment instanceof ConfigurableEnvironment) {
            return ((ConfigurableEnvironment)this.environment).getPropertySources();
        }
        return null;
    }

    private PropertySourcesPlaceholderConfigurer getSinglePropertySourcesPlaceholderConfigurer() {
        if (this.beanFactory instanceof ListableBeanFactory) {
            ListableBeanFactory listableBeanFactory = (ListableBeanFactory)this.beanFactory;
            Map beans = listableBeanFactory.getBeansOfType(PropertySourcesPlaceholderConfigurer.class, false, false);
            if (beans.size() == 1) {
                return (PropertySourcesPlaceholderConfigurer)beans.values().iterator().next();
            }
            if (beans.size() > 1 && logger.isWarnEnabled()) {
                logger.warn((Object)("Multiple PropertySourcesPlaceholderConfigurer beans registered " + beans.keySet() + ", falling back to Environment"));
            }
        }
        return null;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        ConfigurationProperties annotation = this.getAnnotation(bean, beanName);
        if (annotation != null) {
            try {
                this.getBinder().bind(bean, annotation);
            }
            catch (ConfigurationPropertiesBindingException ex) {
                throw new BeanCreationException(beanName, ex.getMessage(), ex.getCause());
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    private ConfigurationProperties getAnnotation(Object bean, String beanName) {
        ConfigurationProperties annotation = this.beans.findFactoryAnnotation(beanName, ConfigurationProperties.class);
        if (annotation == null) {
            annotation = (ConfigurationProperties)AnnotationUtils.findAnnotation(bean.getClass(), ConfigurationProperties.class);
        }
        return annotation;
    }

    private ConfigurationPropertiesBinder getBinder() {
        if (this.configurationPropertiesBinder == null) {
            this.configurationPropertiesBinder = new ConfigurationPropertiesBinderBuilder(this.applicationContext).withPropertySources((Iterable<PropertySource<?>>)this.propertySources).build();
        }
        return this.configurationPropertiesBinder;
    }
}

