/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.PropertyMapper;
import org.springframework.boot.context.properties.source.PropertyMapping;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

final class SystemEnvironmentPropertyMapper
implements PropertyMapper {
    public static final PropertyMapper INSTANCE = new SystemEnvironmentPropertyMapper();

    private SystemEnvironmentPropertyMapper() {
    }

    @Override
    public List<PropertyMapping> map(PropertySource<?> propertySource, String propertySourceName) {
        ConfigurationPropertyName name = this.convertName(propertySourceName);
        if (name == null || name.isEmpty()) {
            return Collections.emptyList();
        }
        if (propertySourceName.endsWith("__")) {
            return this.expandListShortcut(propertySourceName, name, propertySource.getProperty(propertySourceName));
        }
        return Collections.singletonList(new PropertyMapping(propertySourceName, name));
    }

    private ConfigurationPropertyName convertName(String propertySourceName) {
        try {
            return ConfigurationPropertyName.adapt(propertySourceName, '_', this::processElementValue);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private List<PropertyMapping> expandListShortcut(String propertySourceName, ConfigurationPropertyName rootName, Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<PropertyMapping> mappings = new ArrayList<PropertyMapping>();
        String[] elements = StringUtils.commaDelimitedListToStringArray((String)String.valueOf(value));
        for (int i = 0; i < elements.length; ++i) {
            ConfigurationPropertyName name = rootName.append("[" + i + "]");
            mappings.add(new PropertyMapping(propertySourceName, name, new ElementExtractor(i)));
        }
        return mappings;
    }

    @Override
    public List<PropertyMapping> map(PropertySource<?> propertySource, ConfigurationPropertyName configurationPropertyName) {
        String name = this.convertName(configurationPropertyName);
        List<PropertyMapping> result = Collections.singletonList(new PropertyMapping(name, configurationPropertyName));
        if (this.isListShortcutPossible(configurationPropertyName)) {
            result = new ArrayList<PropertyMapping>(result);
            result.addAll(this.mapListShortcut(propertySource, configurationPropertyName));
        }
        return result;
    }

    private String convertName(ConfigurationPropertyName name) {
        return this.convertName(name, name.getNumberOfElements());
    }

    private String convertName(ConfigurationPropertyName name, int numberOfElements) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < numberOfElements; ++i) {
            result.append(result.length() == 0 ? "" : "_");
            result.append(name.getElement(i, ConfigurationPropertyName.Form.UNIFORM).toUpperCase());
        }
        return result.toString();
    }

    private boolean isListShortcutPossible(ConfigurationPropertyName name) {
        return name.isLastElementIndexed() && SystemEnvironmentPropertyMapper.isNumber(name.getLastElement(ConfigurationPropertyName.Form.UNIFORM)) && name.getNumberOfElements() >= 1;
    }

    private List<PropertyMapping> mapListShortcut(PropertySource<?> propertySource, ConfigurationPropertyName name) {
        String result = this.convertName(name, name.getNumberOfElements() - 1) + "__";
        if (propertySource.containsProperty(result)) {
            int index = Integer.parseInt(name.getLastElement(ConfigurationPropertyName.Form.UNIFORM));
            return Collections.singletonList(new PropertyMapping(result, name, new ElementExtractor(index)));
        }
        return Collections.emptyList();
    }

    private CharSequence processElementValue(CharSequence value) {
        String result = value.toString().toLowerCase();
        return SystemEnvironmentPropertyMapper.isNumber(result) ? "[" + result + "]" : result;
    }

    private static boolean isNumber(String string) {
        IntStream nonDigits = string.chars().filter(c -> !Character.isDigit(c));
        boolean hasNonDigit = nonDigits.findFirst().isPresent();
        return !hasNonDigit;
    }

    private static class ElementExtractor
    implements Function<Object, Object> {
        private final int index;

        ElementExtractor(int index) {
            this.index = index;
        }

        @Override
        public Object apply(Object value) {
            if (value == null) {
                return null;
            }
            return StringUtils.commaDelimitedListToStringArray((String)value.toString())[this.index];
        }
    }
}

