/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.OptionHelper;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.boot.logging.logback.ColorConverter;
import org.springframework.boot.logging.logback.ExtendedWhitespaceThrowableProxyConverter;
import org.springframework.boot.logging.logback.LevelRemappingAppender;
import org.springframework.boot.logging.logback.LogbackConfigurator;
import org.springframework.boot.logging.logback.WhitespaceThrowableProxyConverter;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.util.ReflectionUtils;

class DefaultLogbackConfiguration {
    private static final String CONSOLE_LOG_PATTERN = "%clr(%d{${LOG_DATEFORMAT_PATTERN:-yyyy-MM-dd HH:mm:ss.SSS}}){faint} %clr(${LOG_LEVEL_PATTERN:-%5p}) %clr(${PID:- }){magenta} %clr(---){faint} %clr([%15.15t]){faint} %clr(%-40.40logger{39}){cyan} %clr(:){faint} %m%n${LOG_EXCEPTION_CONVERSION_WORD:-%wEx}";
    private static final String FILE_LOG_PATTERN = "%d{${LOG_DATEFORMAT_PATTERN:-yyyy-MM-dd HH:mm:ss.SSS}} ${LOG_LEVEL_PATTERN:-%5p} ${PID:- } --- [%t] %-40.40logger{39} : %m%n${LOG_EXCEPTION_CONVERSION_WORD:-%wEx}";
    private static final String MAX_FILE_SIZE = "10MB";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final PropertyResolver patterns;
    private final LogFile logFile;

    DefaultLogbackConfiguration(LoggingInitializationContext initializationContext, LogFile logFile) {
        this.patterns = this.getPatternsResolver(initializationContext.getEnvironment());
        this.logFile = logFile;
    }

    private PropertyResolver getPatternsResolver(Environment environment) {
        if (environment == null) {
            return new PropertySourcesPropertyResolver(null);
        }
        if (environment instanceof ConfigurableEnvironment) {
            PropertySourcesPropertyResolver resolver = new PropertySourcesPropertyResolver((PropertySources)((ConfigurableEnvironment)environment).getPropertySources());
            resolver.setIgnoreUnresolvableNestedPlaceholders(true);
            return resolver;
        }
        return environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(LogbackConfigurator config) {
        Object object = config.getConfigurationLock();
        synchronized (object) {
            this.base(config);
            Appender<ILoggingEvent> consoleAppender = this.consoleAppender(config);
            if (this.logFile != null) {
                Appender<ILoggingEvent> fileAppender = this.fileAppender(config, this.logFile.toString());
                config.root(Level.INFO, consoleAppender, fileAppender);
            } else {
                config.root(Level.INFO, consoleAppender);
            }
        }
    }

    private void base(LogbackConfigurator config) {
        config.conversionRule("clr", ColorConverter.class);
        config.conversionRule("wex", WhitespaceThrowableProxyConverter.class);
        config.conversionRule("wEx", ExtendedWhitespaceThrowableProxyConverter.class);
        LevelRemappingAppender debugRemapAppender = new LevelRemappingAppender("org.springframework.boot");
        config.start((LifeCycle)debugRemapAppender);
        config.appender("DEBUG_LEVEL_REMAPPER", (Appender<?>)debugRemapAppender);
        config.logger("org.apache.catalina.startup.DigesterFactory", Level.ERROR);
        config.logger("org.apache.catalina.util.LifecycleBase", Level.ERROR);
        config.logger("org.apache.coyote.http11.Http11NioProtocol", Level.WARN);
        config.logger("org.apache.sshd.common.util.SecurityUtils", Level.WARN);
        config.logger("org.apache.tomcat.util.net.NioSelectorPool", Level.WARN);
        config.logger("org.eclipse.jetty.util.component.AbstractLifeCycle", Level.ERROR);
        config.logger("org.hibernate.validator.internal.util.Version", Level.WARN);
        config.logger("org.springframework.boot.actuate.endpoint.jmx", null, false, (Appender<ILoggingEvent>)debugRemapAppender);
    }

    private Appender<ILoggingEvent> consoleAppender(LogbackConfigurator config) {
        ConsoleAppender appender = new ConsoleAppender();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        String logPattern = this.patterns.getProperty("logging.pattern.console", CONSOLE_LOG_PATTERN);
        encoder.setPattern(OptionHelper.substVars((String)logPattern, (PropertyContainer)config.getContext()));
        encoder.setCharset(UTF8);
        config.start((LifeCycle)encoder);
        appender.setEncoder((Encoder)encoder);
        config.appender("CONSOLE", (Appender<?>)appender);
        return appender;
    }

    private Appender<ILoggingEvent> fileAppender(LogbackConfigurator config, String logFile) {
        RollingFileAppender appender = new RollingFileAppender();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        String logPattern = this.patterns.getProperty("logging.pattern.file", FILE_LOG_PATTERN);
        encoder.setPattern(OptionHelper.substVars((String)logPattern, (PropertyContainer)config.getContext()));
        appender.setEncoder((Encoder)encoder);
        config.start((LifeCycle)encoder);
        appender.setFile(logFile);
        this.setRollingPolicy((RollingFileAppender<ILoggingEvent>)appender, config, logFile);
        config.appender("FILE", (Appender<?>)appender);
        return appender;
    }

    private void setRollingPolicy(RollingFileAppender<ILoggingEvent> appender, LogbackConfigurator config, String logFile) {
        SizeAndTimeBasedRollingPolicy rollingPolicy = new SizeAndTimeBasedRollingPolicy();
        rollingPolicy.setFileNamePattern(logFile + ".%d{yyyy-MM-dd}.%i.gz");
        this.setMaxFileSize((SizeAndTimeBasedRollingPolicy<ILoggingEvent>)rollingPolicy, this.patterns.getProperty("logging.file.max-size", MAX_FILE_SIZE));
        rollingPolicy.setMaxHistory(((Integer)this.patterns.getProperty("logging.file.max-history", Integer.class, (Object)0)).intValue());
        appender.setRollingPolicy((RollingPolicy)rollingPolicy);
        rollingPolicy.setParent(appender);
        config.start((LifeCycle)rollingPolicy);
    }

    private void setMaxFileSize(SizeAndTimeBasedRollingPolicy<ILoggingEvent> rollingPolicy, String maxFileSize) {
        try {
            rollingPolicy.setMaxFileSize(FileSize.valueOf((String)maxFileSize));
        }
        catch (NoSuchMethodError ex) {
            Method method = ReflectionUtils.findMethod(SizeAndTimeBasedRollingPolicy.class, (String)"setMaxFileSize", (Class[])new Class[]{String.class});
            ReflectionUtils.invokeMethod((Method)method, rollingPolicy, (Object[])new Object[]{maxFileSize});
        }
    }
}

