/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.undertow;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.DefaultAccessLogReceiver;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.URLResource;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.api.SessionPersistenceManager;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.springframework.boot.web.embedded.undertow.CompositeResourceManager;
import org.springframework.boot.web.embedded.undertow.FileSessionPersistence;
import org.springframework.boot.web.embedded.undertow.JarResourceManager;
import org.springframework.boot.web.embedded.undertow.SslBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServer;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.XnioWorker;

public class UndertowServletWebServerFactory
extends AbstractServletWebServerFactory
implements ResourceLoaderAware {
    private static final Set<Class<?>> NO_CLASSES = Collections.emptySet();
    private List<UndertowBuilderCustomizer> builderCustomizers = new ArrayList<UndertowBuilderCustomizer>();
    private List<UndertowDeploymentInfoCustomizer> deploymentInfoCustomizers = new ArrayList<UndertowDeploymentInfoCustomizer>();
    private ResourceLoader resourceLoader;
    private Integer bufferSize;
    private Integer ioThreads;
    private Integer workerThreads;
    private Boolean directBuffers;
    private File accessLogDirectory;
    private String accessLogPattern;
    private String accessLogPrefix;
    private String accessLogSuffix;
    private boolean accessLogEnabled = false;
    private boolean accessLogRotate = true;
    private boolean useForwardHeaders;
    private boolean eagerInitFilters = true;

    public UndertowServletWebServerFactory() {
        this.getJsp().setRegistered(false);
    }

    public UndertowServletWebServerFactory(int port) {
        super(port);
        this.getJsp().setRegistered(false);
    }

    public UndertowServletWebServerFactory(String contextPath, int port) {
        super(contextPath, port);
        this.getJsp().setRegistered(false);
    }

    public void setBuilderCustomizers(Collection<? extends UndertowBuilderCustomizer> customizers) {
        Assert.notNull(customizers, (String)"Customizers must not be null");
        this.builderCustomizers = new ArrayList<UndertowBuilderCustomizer>(customizers);
    }

    public Collection<UndertowBuilderCustomizer> getBuilderCustomizers() {
        return this.builderCustomizers;
    }

    public void addBuilderCustomizers(UndertowBuilderCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"Customizers must not be null");
        this.builderCustomizers.addAll(Arrays.asList(customizers));
    }

    public void setDeploymentInfoCustomizers(Collection<? extends UndertowDeploymentInfoCustomizer> customizers) {
        Assert.notNull(customizers, (String)"Customizers must not be null");
        this.deploymentInfoCustomizers = new ArrayList<UndertowDeploymentInfoCustomizer>(customizers);
    }

    public Collection<UndertowDeploymentInfoCustomizer> getDeploymentInfoCustomizers() {
        return this.deploymentInfoCustomizers;
    }

    public void addDeploymentInfoCustomizers(UndertowDeploymentInfoCustomizer ... customizers) {
        Assert.notNull((Object)customizers, (String)"UndertowDeploymentInfoCustomizers must not be null");
        this.deploymentInfoCustomizers.addAll(Arrays.asList(customizers));
    }

    @Override
    public WebServer getWebServer(ServletContextInitializer ... initializers) {
        DeploymentManager manager = this.createDeploymentManager(initializers);
        int port = this.getPort();
        Undertow.Builder builder = this.createBuilder(port);
        return this.getUndertowWebServer(builder, manager, port);
    }

    private Undertow.Builder createBuilder(int port) {
        Undertow.Builder builder = Undertow.builder();
        if (this.bufferSize != null) {
            builder.setBufferSize(this.bufferSize.intValue());
        }
        if (this.ioThreads != null) {
            builder.setIoThreads(this.ioThreads.intValue());
        }
        if (this.workerThreads != null) {
            builder.setWorkerThreads(this.workerThreads.intValue());
        }
        if (this.directBuffers != null) {
            builder.setDirectBuffers(this.directBuffers.booleanValue());
        }
        if (this.getSsl() != null && this.getSsl().isEnabled()) {
            this.customizeSsl(builder);
        } else {
            builder.addHttpListener(port, this.getListenAddress());
        }
        for (UndertowBuilderCustomizer customizer : this.builderCustomizers) {
            customizer.customize(builder);
        }
        return builder;
    }

    private void customizeSsl(Undertow.Builder builder) {
        new SslBuilderCustomizer(this.getPort(), this.getAddress(), this.getSsl(), this.getSslStoreProvider()).customize(builder);
        if (this.getHttp2() != null) {
            builder.setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)this.getHttp2().getEnabled());
        }
    }

    private String getListenAddress() {
        if (this.getAddress() == null) {
            return "0.0.0.0";
        }
        return this.getAddress().getHostAddress();
    }

    private DeploymentManager createDeploymentManager(ServletContextInitializer ... initializers) {
        DeploymentInfo deployment = Servlets.deployment();
        this.registerServletContainerInitializerToDriveServletContextInitializers(deployment, initializers);
        deployment.setClassLoader(this.getServletClassLoader());
        deployment.setContextPath(this.getContextPath());
        deployment.setDisplayName(this.getDisplayName());
        deployment.setDeploymentName("spring-boot");
        if (this.isRegisterDefaultServlet()) {
            deployment.addServlet(Servlets.servlet((String)"default", DefaultServlet.class));
        }
        this.configureErrorPages(deployment);
        deployment.setServletStackTraces(ServletStackTraces.NONE);
        deployment.setResourceManager(this.getDocumentRootResourceManager());
        deployment.setEagerFilterInit(this.eagerInitFilters);
        this.configureMimeMappings(deployment);
        for (UndertowDeploymentInfoCustomizer customizer : this.deploymentInfoCustomizers) {
            customizer.customize(deployment);
        }
        if (this.isAccessLogEnabled()) {
            this.configureAccessLog(deployment);
        }
        if (this.isPersistSession()) {
            File dir = this.getValidSessionStoreDir();
            deployment.setSessionPersistenceManager((SessionPersistenceManager)new FileSessionPersistence(dir));
        }
        this.addLocaleMappings(deployment);
        DeploymentManager manager = Servlets.newContainer().addDeployment(deployment);
        manager.deploy();
        SessionManager sessionManager = manager.getDeployment().getSessionManager();
        int sessionTimeout = this.getSessionTimeout() > 0 ? this.getSessionTimeout() : -1;
        sessionManager.setDefaultSessionTimeout(sessionTimeout);
        return manager;
    }

    private void configureAccessLog(DeploymentInfo deploymentInfo) {
        deploymentInfo.addInitialHandlerChainWrapper(this::createAccessLogHandler);
    }

    private AccessLogHandler createAccessLogHandler(HttpHandler handler) {
        try {
            this.createAccessLogDirectoryIfNecessary();
            String prefix = this.accessLogPrefix != null ? this.accessLogPrefix : "access_log.";
            DefaultAccessLogReceiver accessLogReceiver = new DefaultAccessLogReceiver((Executor)this.createWorker(), this.accessLogDirectory, prefix, this.accessLogSuffix, this.accessLogRotate);
            String formatString = this.accessLogPattern != null ? this.accessLogPattern : "common";
            return new AccessLogHandler(handler, (AccessLogReceiver)accessLogReceiver, formatString, Undertow.class.getClassLoader());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to create AccessLogHandler", ex);
        }
    }

    private void createAccessLogDirectoryIfNecessary() {
        Assert.state((this.accessLogDirectory != null ? 1 : 0) != 0, (String)"Access log directory is not set");
        if (!this.accessLogDirectory.isDirectory() && !this.accessLogDirectory.mkdirs()) {
            throw new IllegalStateException("Failed to create access log directory '" + this.accessLogDirectory + "'");
        }
    }

    private XnioWorker createWorker() throws IOException {
        Xnio xnio = Xnio.getInstance((ClassLoader)Undertow.class.getClassLoader());
        return xnio.createWorker(OptionMap.builder().set(Options.THREAD_DAEMON, true).getMap());
    }

    private void addLocaleMappings(DeploymentInfo deployment) {
        for (Map.Entry<Locale, Charset> entry : this.getLocaleCharsetMappings().entrySet()) {
            Locale locale = entry.getKey();
            Charset charset = entry.getValue();
            deployment.addLocaleCharsetMapping(locale.toString(), charset.toString());
        }
    }

    private void registerServletContainerInitializerToDriveServletContextInitializers(DeploymentInfo deployment, ServletContextInitializer ... initializers) {
        ServletContextInitializer[] mergedInitializers = this.mergeInitializers(initializers);
        Initializer initializer = new Initializer(mergedInitializers);
        deployment.addServletContainerInitalizer(new ServletContainerInitializerInfo(Initializer.class, (InstanceFactory)new ImmediateInstanceFactory((Object)initializer), NO_CLASSES));
    }

    private ClassLoader getServletClassLoader() {
        if (this.resourceLoader != null) {
            return this.resourceLoader.getClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    private ResourceManager getDocumentRootResourceManager() {
        File root = this.getValidDocumentRoot();
        File docBase = this.getCanonicalDocumentRoot(root);
        List<URL> metaInfResourceUrls = this.getUrlsOfJarsWithMetaInfResources();
        ArrayList<URL> resourceJarUrls = new ArrayList<URL>();
        ArrayList<Object> resourceManagers = new ArrayList<Object>();
        Object rootResourceManager = docBase.isDirectory() ? new FileResourceManager(docBase, 0L) : new JarResourceManager(docBase);
        resourceManagers.add(root == null ? rootResourceManager : new LoaderHidingResourceManager((ResourceManager)rootResourceManager));
        for (URL url : metaInfResourceUrls) {
            if ("file".equals(url.getProtocol())) {
                File file = new File(url.getFile());
                if (file.isFile()) {
                    try {
                        resourceJarUrls.add(new URL("jar:" + url + "!/"));
                        continue;
                    }
                    catch (MalformedURLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                resourceManagers.add(new FileResourceManager(new File(file, "META-INF/resources"), 0L));
                continue;
            }
            resourceJarUrls.add(url);
        }
        resourceManagers.add(new MetaInfResourcesResourceManager(resourceJarUrls));
        return new CompositeResourceManager(resourceManagers.toArray(new ResourceManager[resourceManagers.size()]));
    }

    private File getCanonicalDocumentRoot(File docBase) {
        try {
            File root = docBase != null ? docBase : this.createTempDir("undertow-docbase");
            return root.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot get canonical document root", e);
        }
    }

    private void configureErrorPages(DeploymentInfo servletBuilder) {
        for (ErrorPage errorPage : this.getErrorPages()) {
            servletBuilder.addErrorPage(this.getUndertowErrorPage(errorPage));
        }
    }

    private io.undertow.servlet.api.ErrorPage getUndertowErrorPage(ErrorPage errorPage) {
        if (errorPage.getStatus() != null) {
            return new io.undertow.servlet.api.ErrorPage(errorPage.getPath(), errorPage.getStatusCode());
        }
        if (errorPage.getException() != null) {
            return new io.undertow.servlet.api.ErrorPage(errorPage.getPath(), errorPage.getException());
        }
        return new io.undertow.servlet.api.ErrorPage(errorPage.getPath());
    }

    private void configureMimeMappings(DeploymentInfo servletBuilder) {
        for (MimeMappings.Mapping mimeMapping : this.getMimeMappings()) {
            servletBuilder.addMimeMapping(new MimeMapping(mimeMapping.getExtension(), mimeMapping.getMimeType()));
        }
    }

    protected UndertowServletWebServer getUndertowWebServer(Undertow.Builder builder, DeploymentManager manager, int port) {
        return new UndertowServletWebServer(builder, manager, this.getContextPath(), this.isUseForwardHeaders(), port >= 0, this.getCompression(), this.getServerHeader());
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setIoThreads(Integer ioThreads) {
        this.ioThreads = ioThreads;
    }

    public void setWorkerThreads(Integer workerThreads) {
        this.workerThreads = workerThreads;
    }

    public void setDirectBuffers(Boolean directBuffers) {
        this.directBuffers = directBuffers;
    }

    public void setAccessLogDirectory(File accessLogDirectory) {
        this.accessLogDirectory = accessLogDirectory;
    }

    public void setAccessLogPattern(String accessLogPattern) {
        this.accessLogPattern = accessLogPattern;
    }

    public String getAccessLogPrefix() {
        return this.accessLogPrefix;
    }

    public void setAccessLogPrefix(String accessLogPrefix) {
        this.accessLogPrefix = accessLogPrefix;
    }

    public void setAccessLogSuffix(String accessLogSuffix) {
        this.accessLogSuffix = accessLogSuffix;
    }

    public void setAccessLogEnabled(boolean accessLogEnabled) {
        this.accessLogEnabled = accessLogEnabled;
    }

    public boolean isAccessLogEnabled() {
        return this.accessLogEnabled;
    }

    public void setAccessLogRotate(boolean accessLogRotate) {
        this.accessLogRotate = accessLogRotate;
    }

    protected final boolean isUseForwardHeaders() {
        return this.useForwardHeaders;
    }

    public void setUseForwardHeaders(boolean useForwardHeaders) {
        this.useForwardHeaders = useForwardHeaders;
    }

    public boolean isEagerInitFilters() {
        return this.eagerInitFilters;
    }

    public void setEagerInitFilters(boolean eagerInitFilters) {
        this.eagerInitFilters = eagerInitFilters;
    }

    private static final class LoaderHidingResourceManager
    implements ResourceManager {
        private final ResourceManager delegate;

        private LoaderHidingResourceManager(ResourceManager delegate) {
            this.delegate = delegate;
        }

        public Resource getResource(String path) throws IOException {
            if (path.startsWith("/org/springframework/boot")) {
                return null;
            }
            return this.delegate.getResource(path);
        }

        public boolean isResourceChangeListenerSupported() {
            return this.delegate.isResourceChangeListenerSupported();
        }

        public void registerResourceChangeListener(ResourceChangeListener listener) {
            this.delegate.registerResourceChangeListener(listener);
        }

        public void removeResourceChangeListener(ResourceChangeListener listener) {
            this.delegate.removeResourceChangeListener(listener);
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }

    private static class Initializer
    implements ServletContainerInitializer {
        private final ServletContextInitializer[] initializers;

        Initializer(ServletContextInitializer[] initializers) {
            this.initializers = initializers;
        }

        public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
            for (ServletContextInitializer initializer : this.initializers) {
                initializer.onStartup(servletContext);
            }
        }
    }

    private static final class MetaInfResourcesResourceManager
    implements ResourceManager {
        private final List<URL> metaInfResourceJarUrls;

        private MetaInfResourcesResourceManager(List<URL> metaInfResourceJarUrls) {
            this.metaInfResourceJarUrls = metaInfResourceJarUrls;
        }

        public void close() throws IOException {
        }

        public Resource getResource(String path) {
            for (URL url : this.metaInfResourceJarUrls) {
                URLResource resource = this.getMetaInfResource(url, path);
                if (resource == null) continue;
                return resource;
            }
            return null;
        }

        public boolean isResourceChangeListenerSupported() {
            return false;
        }

        public void registerResourceChangeListener(ResourceChangeListener listener) {
        }

        public void removeResourceChangeListener(ResourceChangeListener listener) {
        }

        private URLResource getMetaInfResource(URL resourceJar, String path) {
            try {
                URL resourceUrl = new URL(resourceJar + "META-INF/resources" + path);
                URLResource resource = new URLResource(resourceUrl, path);
                if (resource.getContentLength() < 0L) {
                    return null;
                }
                return resource;
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
    }
}

