/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.util.StringUtils;

class StandardConfigDataReference {
    private final ConfigDataLocation configDataLocation;
    private final String resourceLocation;
    private final @Nullable String directory;
    private final @Nullable String profile;
    private final PropertySourceLoader propertySourceLoader;

    StandardConfigDataReference(ConfigDataLocation configDataLocation, @Nullable String directory, String root, @Nullable String profile, @Nullable String extension, PropertySourceLoader propertySourceLoader) {
        this.configDataLocation = configDataLocation;
        Object profileSuffix = StringUtils.hasText((String)profile) ? "-" + profile : "";
        this.resourceLocation = root + (String)profileSuffix + (String)(extension != null ? "." + extension : "");
        this.directory = directory;
        this.profile = profile;
        this.propertySourceLoader = propertySourceLoader;
    }

    ConfigDataLocation getConfigDataLocation() {
        return this.configDataLocation;
    }

    String getResourceLocation() {
        return this.resourceLocation;
    }

    boolean isMandatoryDirectory() {
        return !this.configDataLocation.isOptional() && this.directory != null;
    }

    @Nullable String getDirectory() {
        return this.directory;
    }

    @Nullable String getProfile() {
        return this.profile;
    }

    boolean isSkippable() {
        return this.configDataLocation.isOptional() || this.directory != null || this.profile != null;
    }

    PropertySourceLoader getPropertySourceLoader() {
        return this.propertySourceLoader;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StandardConfigDataReference other = (StandardConfigDataReference)obj;
        return this.resourceLocation.equals(other.resourceLocation);
    }

    public int hashCode() {
        return this.resourceLocation.hashCode();
    }

    public String toString() {
        return this.resourceLocation;
    }
}

