/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.build.aws.maven;

import com.amazonaws.ClientConfiguration;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyInfoProvider;
import org.apache.maven.wagon.repository.Repository;

final class S3Utils {
    private S3Utils() {
    }

    static String getBucketName(Repository repository) {
        return repository.getHost();
    }

    static String getBaseDirectory(Repository repository) {
        StringBuilder sb = new StringBuilder(repository.getBasedir()).deleteCharAt(0);
        if (sb.length() != 0 && sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        return sb.toString();
    }

    static ClientConfiguration getClientConfiguration(ProxyInfoProvider proxyInfoProvider) {
        ProxyInfo proxyInfo;
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        if (proxyInfoProvider != null && (proxyInfo = proxyInfoProvider.getProxyInfo("http")) != null) {
            clientConfiguration.withProxyHost(proxyInfo.getHost()).withProxyPort(proxyInfo.getPort());
        }
        return clientConfiguration;
    }
}

