/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.autoconfigure.mail;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient;
import javax.mail.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.cloud.aws.autoconfigure.context.ContextCredentialsAutoConfiguration;
import org.springframework.cloud.aws.context.annotation.ConditionalOnMissingAmazonClient;
import org.springframework.cloud.aws.core.region.RegionProvider;
import org.springframework.cloud.aws.mail.simplemail.SimpleEmailServiceJavaMailSender;
import org.springframework.cloud.aws.mail.simplemail.SimpleEmailServiceMailSender;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.mail.MailSender;
import org.springframework.mail.javamail.JavaMailSender;

@Configuration
@ConditionalOnClass(value={MailSender.class})
@Import(value={ContextCredentialsAutoConfiguration.class})
public class MailSenderAutoConfiguration {
    @Autowired(required=false)
    private RegionProvider regionProvider;

    @Bean
    @ConditionalOnMissingAmazonClient(value=AmazonSimpleEmailService.class)
    public AmazonSimpleEmailService amazonSimpleEmailService(AWSCredentialsProvider credentialsProvider) {
        AmazonSimpleEmailServiceClient serviceClient = new AmazonSimpleEmailServiceClient(credentialsProvider);
        if (this.regionProvider != null) {
            serviceClient.setRegion(this.regionProvider.getRegion());
        }
        return serviceClient;
    }

    @Bean
    @ConditionalOnMissingClass(name={"org.springframework.cloud.aws.mail.simplemail.SimpleEmailServiceJavaMailSender"})
    public MailSender simpleMailSender(AmazonSimpleEmailService amazonSimpleEmailService) {
        return new SimpleEmailServiceMailSender(amazonSimpleEmailService);
    }

    @Bean
    @ConditionalOnClass(value={Session.class})
    public JavaMailSender javaMailSender(AmazonSimpleEmailService amazonSimpleEmailService) {
        return new SimpleEmailServiceJavaMailSender(amazonSimpleEmailService);
    }
}

