/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.context.config.xml;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cloud.aws.core.config.AmazonWebserviceClientConfigurationUtils;
import org.springframework.cloud.aws.core.credentials.CredentialsProviderFactoryBean;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class ContextCredentialsBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String STATIC_CREDENTIALS_PROVIDER_BEAN_CLASS_NAME = "com.amazonaws.internal.StaticCredentialsProvider";
    private static final String INSTANCE_CREDENTIALS_PROVIDER_BEAN_CLASS_NAME = "com.amazonaws.auth.InstanceProfileCredentialsProvider";
    private static final String PROFILE_CREDENTIALS_PROVIDER_BEAN_CLASS_NAME = "com.amazonaws.auth.profile.ProfileCredentialsProvider";
    private static final String ACCESS_KEY_ATTRIBUTE_NAME = "access-key";
    private static final String SECRET_KEY_ATTRIBUTE_NAME = "secret-key";

    ContextCredentialsBeanDefinitionParser() {
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        return "credentialsProvider";
    }

    protected Class<?> getBeanClass(Element element) {
        return CredentialsProviderFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (parserContext.getRegistry().containsBeanDefinition("credentialsProvider")) {
            parserContext.getReaderContext().error("Multiple <context-credentials/> detected. The <context-credentials/> is only allowed once per application context", (Object)element);
        }
        List elements = DomUtils.getChildElements((Element)element);
        ManagedList credentialsProviders = new ManagedList(elements.size());
        for (Element credentialsProviderElement : elements) {
            if ("simple-credentials".equals(credentialsProviderElement.getLocalName())) {
                credentialsProviders.add((Object)ContextCredentialsBeanDefinitionParser.getCredentialsProvider(STATIC_CREDENTIALS_PROVIDER_BEAN_CLASS_NAME, ContextCredentialsBeanDefinitionParser.getCredentials(credentialsProviderElement, parserContext)));
            }
            if ("instance-profile-credentials".equals(credentialsProviderElement.getLocalName())) {
                credentialsProviders.add((Object)ContextCredentialsBeanDefinitionParser.getCredentialsProvider(INSTANCE_CREDENTIALS_PROVIDER_BEAN_CLASS_NAME, new Object[0]));
            }
            if (!"profile-credentials".equals(credentialsProviderElement.getLocalName())) continue;
            credentialsProviders.add((Object)ContextCredentialsBeanDefinitionParser.getCredentialsProvider(PROFILE_CREDENTIALS_PROVIDER_BEAN_CLASS_NAME, ContextCredentialsBeanDefinitionParser.getProfileConfiguration(credentialsProviderElement).toArray()));
        }
        builder.addConstructorArgValue((Object)credentialsProviders);
        AmazonWebserviceClientConfigurationUtils.replaceDefaultCredentialsProvider((BeanDefinitionRegistry)parserContext.getRegistry(), (String)"credentialsProvider");
    }

    private static BeanDefinition getCredentialsProvider(String credentialsProviderClassName, Object ... constructorArg) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)credentialsProviderClassName);
        Object[] objectArray = constructorArg;
        int n = constructorArg.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            beanDefinitionBuilder.addConstructorArgValue(o);
            ++n2;
        }
        return beanDefinitionBuilder.getBeanDefinition();
    }

    private static BeanDefinition getCredentials(Element credentialsProviderElement, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)"com.amazonaws.auth.BasicAWSCredentials");
        builder.addConstructorArgValue((Object)ContextCredentialsBeanDefinitionParser.getAttributeValue(ACCESS_KEY_ATTRIBUTE_NAME, credentialsProviderElement, parserContext));
        builder.addConstructorArgValue((Object)ContextCredentialsBeanDefinitionParser.getAttributeValue(SECRET_KEY_ATTRIBUTE_NAME, credentialsProviderElement, parserContext));
        return builder.getBeanDefinition();
    }

    private static List<String> getProfileConfiguration(Element element) {
        ArrayList<String> constructorArguments = new ArrayList<String>(2);
        if (StringUtils.hasText((String)element.getAttribute("profilePath"))) {
            constructorArguments.add(element.getAttribute("profilePath"));
        }
        if (StringUtils.hasText((String)element.getAttribute("profileName"))) {
            constructorArguments.add(element.getAttribute("profileName"));
        }
        return constructorArguments;
    }

    private static String getAttributeValue(String attribute, Element element, ParserContext parserContext) {
        String attributeValue = element.getAttribute(attribute);
        if (!StringUtils.hasText((String)attributeValue)) {
            parserContext.getReaderContext().error("The '" + attribute + "' attribute must not be empty", (Object)element);
        }
        return attributeValue;
    }
}

