/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.jdbc.retry;

import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.aws.jdbc.retry.JdbcRetryException;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;
import org.springframework.retry.support.RetrySynchronizationManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class RdbmsRetryOperationsInterceptor
extends RetryOperationsInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdbmsRetryOperationsInterceptor.class);

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result;
        if (!this.isRetryContextOperationActive()) {
            RdbmsRetryOperationsInterceptor.assertNoTransactionActive();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Starting a new Retry Interceptor for {}", (Object)(invocation != null ? invocation.getMethod() : null));
            }
            result = super.invoke(invocation);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Finished a new Retry Interceptor for {}", (Object)(invocation != null ? invocation.getMethod() : null));
            }
        } else {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Participating in existing retry operation");
            }
            result = invocation.proceed();
        }
        return result;
    }

    protected boolean isRetryContextOperationActive() {
        return RetrySynchronizationManager.getContext() != null;
    }

    private static void assertNoTransactionActive() {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new JdbcRetryException("An active transaction was found.  This is not allowed when starting a retryable operation.");
        }
    }
}

