/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.support;

import org.springframework.cloud.aws.messaging.config.annotation.NotificationMessage;
import org.springframework.cloud.aws.messaging.support.converter.NotificationRequestConverter;
import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.util.ClassUtils;

public class NotificationMessageArgumentResolver
implements HandlerMethodArgumentResolver {
    private final MessageConverter converter = new NotificationRequestConverter();

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(NotificationMessage.class) && ClassUtils.isAssignable(String.class, (Class)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
        return ((NotificationRequestConverter.NotificationRequest)this.converter.fromMessage(message, String.class)).getMessage();
    }
}

