/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.util.HashMap;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.PropertySourceContributor;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public final class BindingFlattenedEnvironmentPostProcessor
implements ApplicationListener<ApplicationPreparedEvent>,
EnvironmentPostProcessor,
Ordered {
    public static final String BINDING_FLATTENED_PROPERTY_SOURCE_NAME = "kubernetesServiceBindingFlattened";
    private final DeferredLog log = new DeferredLog();
    private final Bindings bindings;

    public BindingFlattenedEnvironmentPostProcessor() {
        this(new Bindings());
    }

    BindingFlattenedEnvironmentPostProcessor(Bindings bindings) {
        this.bindings = bindings;
    }

    public int getOrder() {
        return -2147483639;
    }

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        this.log.replayTo(this.getClass());
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.bindings.getBindings().forEach(binding -> binding.getSecret().forEach((key, value) -> properties.put(String.format("k8s.bindings.%s.%s", binding.getName(), key), value)));
        if (properties.isEmpty()) {
            this.log.debug((Object)"No properties set from Kubernetes Service Bindings. Skipping PropertySource creation.");
            return;
        }
        this.log.info((Object)"Creating flattened PropertySource from Kubernetes Service Bindings");
        PropertySourceContributor.contributePropertySource(BINDING_FLATTENED_PROPERTY_SOURCE_NAME, properties, environment);
    }
}

