/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot.pem;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Random;
import org.springframework.cloud.bindings.boot.pem.PemCertificateParser;
import org.springframework.cloud.bindings.boot.pem.PemContent;
import org.springframework.cloud.bindings.boot.pem.PemPrivateKeyParser;
import org.springframework.util.Assert;

public class PemSslStoreHelper {
    public static final String PKCS12_STORY_TYPE = "PKCS12";
    private static final String DEFAULT_KEY_ALIAS = "ssl";

    public static Path createKeyStoreFile(String name, String password, String certificate, String privateKey, String keyAlias) {
        Path path;
        KeyStore store = PemSslStoreHelper.createKeyStore(certificate, privateKey, keyAlias);
        try {
            path = Files.createTempFile(Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), name, ".p12", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create " + name, e);
        }
        try (FileOutputStream fos = new FileOutputStream(path.toString());){
            store.store(fos, password.toCharArray());
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Unable to write " + name, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cryptographic algorithm not available", e);
        }
        catch (CertificateException e) {
            throw new IllegalStateException("Unable to process certificate", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create " + name, e);
        }
        return path;
    }

    public static String generatePassword() {
        return new Random().ints(97, 123).limit(10L).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private static KeyStore createKeyStore(String certificate, String privateKey, String keyAlias) {
        try {
            Assert.notNull((Object)certificate, (String)"CertificateContent must not be null");
            KeyStore store = KeyStore.getInstance(PKCS12_STORY_TYPE);
            store.load(null);
            String certificateContent = PemContent.load(certificate);
            String privateKeyContent = PemContent.load(privateKey);
            X509Certificate[] certificates = PemCertificateParser.parse(certificateContent);
            PrivateKey pk = PemPrivateKeyParser.parse(privateKeyContent);
            PemSslStoreHelper.addCertificates(store, certificates, pk, keyAlias);
            return store;
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("Unable to create key/trust store: %s", ex.getMessage()), ex);
        }
    }

    private static void addCertificates(KeyStore keyStore, X509Certificate[] certificates, PrivateKey privateKey, String keyAlias) throws KeyStoreException {
        String alias;
        String string = alias = keyAlias != null ? keyAlias : DEFAULT_KEY_ALIAS;
        if (privateKey != null) {
            keyStore.setKeyEntry(alias, privateKey, null, certificates);
        } else {
            for (int index = 0; index < certificates.length; ++index) {
                keyStore.setCertificateEntry(alias + "-" + index, certificates[index]);
            }
        }
    }
}

