/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.circuitbreaker.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.reactor.circuitbreaker.operator.CircuitBreakerOperator;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JConfigBuilder;
import org.springframework.cloud.client.circuitbreaker.Customizer;
import org.springframework.cloud.client.circuitbreaker.ReactiveCircuitBreaker;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class ReactiveResilience4JCircuitBreaker
implements ReactiveCircuitBreaker {
    private final String id;
    private final String groupName;
    private final CircuitBreakerConfig circuitBreakerConfig;
    private final CircuitBreakerRegistry circuitBreakerRegistry;
    private final TimeLimiterConfig timeLimiterConfig;
    private final TimeLimiterRegistry timeLimiterRegistry;
    private final Optional<Customizer<CircuitBreaker>> circuitBreakerCustomizer;
    private final boolean disableTimeLimiter;

    @Deprecated
    public ReactiveResilience4JCircuitBreaker(String id, String groupName, Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration config, CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry, Optional<Customizer<CircuitBreaker>> circuitBreakerCustomizer) {
        this(id, groupName, config, circuitBreakerRegistry, timeLimiterRegistry, circuitBreakerCustomizer, false);
    }

    public ReactiveResilience4JCircuitBreaker(String id, String groupName, Resilience4JConfigBuilder.Resilience4JCircuitBreakerConfiguration config, CircuitBreakerRegistry circuitBreakerRegistry, TimeLimiterRegistry timeLimiterRegistry, Optional<Customizer<CircuitBreaker>> circuitBreakerCustomizer, boolean disableTimeLimiter) {
        this.id = id;
        this.groupName = groupName;
        this.circuitBreakerConfig = config.getCircuitBreakerConfig();
        this.circuitBreakerRegistry = circuitBreakerRegistry;
        this.circuitBreakerCustomizer = circuitBreakerCustomizer;
        this.timeLimiterConfig = config.getTimeLimiterConfig();
        this.timeLimiterRegistry = timeLimiterRegistry;
        this.disableTimeLimiter = disableTimeLimiter;
    }

    public <T> Mono<T> run(Mono<T> toRun, Function<Throwable, Mono<T>> fallback) {
        Tuple2<CircuitBreaker, Optional<TimeLimiter>> tuple = this.buildCircuitBreakerAndTimeLimiter();
        Mono toReturn = toRun.transform((Function)CircuitBreakerOperator.of((CircuitBreaker)((CircuitBreaker)tuple.getT1())));
        if (((Optional)tuple.getT2()).isPresent()) {
            Duration timeoutDuration = ((TimeLimiter)((Optional)tuple.getT2()).get()).getTimeLimiterConfig().getTimeoutDuration();
            toReturn = toReturn.timeout(timeoutDuration).doOnError(TimeoutException.class, t -> ((CircuitBreaker)tuple.getT1()).onError(timeoutDuration.toMillis(), TimeUnit.MILLISECONDS, (Throwable)t));
        }
        if (fallback != null) {
            toReturn = toReturn.onErrorResume(fallback);
        }
        return toReturn;
    }

    public <T> Flux<T> run(Flux<T> toRun, Function<Throwable, Flux<T>> fallback) {
        Tuple2<CircuitBreaker, Optional<TimeLimiter>> tuple = this.buildCircuitBreakerAndTimeLimiter();
        Flux toReturn = toRun.transform((Function)CircuitBreakerOperator.of((CircuitBreaker)((CircuitBreaker)tuple.getT1())));
        if (((Optional)tuple.getT2()).isPresent()) {
            Duration timeoutDuration = ((TimeLimiter)((Optional)tuple.getT2()).get()).getTimeLimiterConfig().getTimeoutDuration();
            toReturn = toReturn.timeout(timeoutDuration).doOnError(TimeoutException.class, t -> ((CircuitBreaker)tuple.getT1()).onError(timeoutDuration.toMillis(), TimeUnit.MILLISECONDS, (Throwable)t));
        }
        if (fallback != null) {
            toReturn = toReturn.onErrorResume(fallback);
        }
        return toReturn;
    }

    private Tuple2<CircuitBreaker, Optional<TimeLimiter>> buildCircuitBreakerAndTimeLimiter() {
        Map<String, String> tags = Map.of("group", this.groupName);
        CircuitBreaker circuitBreaker = this.circuitBreakerRegistry.circuitBreaker(this.id, this.circuitBreakerConfig, tags);
        this.circuitBreakerCustomizer.ifPresent(customizer -> customizer.customize((Object)circuitBreaker));
        if (this.disableTimeLimiter) {
            return Tuples.of((Object)circuitBreaker, Optional.empty());
        }
        TimeLimiter timeLimiter = this.timeLimiterRegistry.find(this.id).orElseGet(() -> this.timeLimiterRegistry.find(this.groupName).orElseGet(() -> this.timeLimiterRegistry.timeLimiter(this.id, this.timeLimiterConfig, tags)));
        return Tuples.of((Object)circuitBreaker, Optional.of(timeLimiter));
    }
}

