/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.exc;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonLocation;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.databind.JsonMappingException;

public abstract class PropertyBindingException
extends JsonMappingException {
    protected final Class<?> _referringClass;
    protected final String _propertyName;
    protected final Collection<Object> _propertyIds;
    protected transient String _propertiesAsString;
    private static final int MAX_DESC_LENGTH = 200;

    protected PropertyBindingException(String string, JsonLocation jsonLocation, Class<?> clazz, String string2, Collection<Object> collection) {
        super(string, jsonLocation);
        this._referringClass = clazz;
        this._propertyName = string2;
        this._propertyIds = collection;
    }

    @Override
    public String getMessageSuffix() {
        String string = this._propertiesAsString;
        if (string == null && this._propertyIds != null) {
            StringBuilder stringBuilder = new StringBuilder(100);
            int n = this._propertyIds.size();
            if (n == 1) {
                stringBuilder.append(" (one known property: \"");
                stringBuilder.append(String.valueOf(this._propertyIds.iterator().next()));
                stringBuilder.append('\"');
            } else {
                stringBuilder.append(" (").append(n).append(" known properties: ");
                Iterator<Object> iterator = this._propertyIds.iterator();
                while (iterator.hasNext()) {
                    stringBuilder.append('\"');
                    stringBuilder.append(String.valueOf(iterator.next()));
                    stringBuilder.append('\"');
                    if (stringBuilder.length() > 200) {
                        stringBuilder.append(" [truncated]");
                        break;
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
            }
            stringBuilder.append("])");
            this._propertiesAsString = string = stringBuilder.toString();
        }
        return string;
    }

    public Class<?> getReferringClass() {
        return this._referringClass;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public Collection<Object> getKnownPropertyIds() {
        if (this._propertyIds == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this._propertyIds);
    }
}

