/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry;

import java.util.Map;
import org.springframework.cloud.cloudfoundry.CloudFoundryServiceInfoCreator;
import org.springframework.cloud.cloudfoundry.Tags;
import org.springframework.cloud.service.common.RedisServiceInfo;

public class RedisServiceInfoCreator
extends CloudFoundryServiceInfoCreator<RedisServiceInfo> {
    public RedisServiceInfoCreator() {
        super(new Tags("redis"), "redis");
    }

    public RedisServiceInfo createServiceInfo(Map<String, Object> serviceData) {
        String id = (String)serviceData.get("name");
        Map<String, Object> credentials = this.getCredentials(serviceData);
        String uri = this.getUriFromCredentials(credentials);
        if (uri == null) {
            String host = this.getStringFromCredentials(credentials, "hostname", "host");
            Integer port = this.getIntFromCredentials(credentials, "port");
            String password = (String)credentials.get("password");
            return new RedisServiceInfo(id, host, port.intValue(), password);
        }
        return new RedisServiceInfo(id, uri);
    }
}

