/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry;

import java.util.Map;
import org.springframework.cloud.cloudfoundry.CloudFoundryServiceInfoCreator;
import org.springframework.cloud.cloudfoundry.Tags;
import org.springframework.cloud.service.common.RelationalServiceInfo;
import org.springframework.cloud.util.UriInfo;

public abstract class RelationalServiceInfoCreator<SI extends RelationalServiceInfo>
extends CloudFoundryServiceInfoCreator<SI> {
    public RelationalServiceInfoCreator(Tags tags, String ... uriSchemes) {
        super(tags, uriSchemes);
    }

    public abstract SI createServiceInfo(String var1, String var2);

    public SI createServiceInfo(Map<String, Object> serviceData) {
        String id = (String)serviceData.get("name");
        Map<String, Object> credentials = this.getCredentials(serviceData);
        String uri = this.getUriFromCredentials(credentials);
        if (uri == null) {
            String host = this.getStringFromCredentials(credentials, "hostname", "host");
            int port = this.getIntFromCredentials(credentials, "port");
            String username = this.getStringFromCredentials(credentials, "user", "username");
            String password = (String)credentials.get("password");
            String database = (String)credentials.get("name");
            uri = new UriInfo(this.getDefaultUriScheme(), host, port, username, password, database).toString();
        }
        return this.createServiceInfo(id, uri);
    }
}

