/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.json;

import java.io.IOException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonGenerationException;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.JsonGenerator;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.ObjectCodec;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.SerializableString;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.Version;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.base.GeneratorBase;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.io.CharTypes;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.io.CharacterEscapes;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.io.IOContext;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import org.springframework.cloud.cloudfoundry.com.fasterxml.jackson.core.util.VersionUtil;

public abstract class JsonGeneratorImpl
extends GeneratorBase {
    protected static final int[] sOutputEscapes = CharTypes.get7BitOutputEscapes();
    protected final IOContext _ioContext;
    protected int[] _outputEscapes = sOutputEscapes;
    protected int _maximumNonEscapedChar;
    protected CharacterEscapes _characterEscapes;
    protected SerializableString _rootValueSeparator = DefaultPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR;

    public JsonGeneratorImpl(IOContext iOContext, int n, ObjectCodec objectCodec) {
        super(n, objectCodec);
        this._ioContext = iOContext;
        if (this.isEnabled(JsonGenerator.Feature.ESCAPE_NON_ASCII)) {
            this.setHighestNonEscapedChar(127);
        }
    }

    @Override
    public JsonGenerator setHighestNonEscapedChar(int n) {
        this._maximumNonEscapedChar = n < 0 ? 0 : n;
        return this;
    }

    @Override
    public int getHighestEscapedChar() {
        return this._maximumNonEscapedChar;
    }

    @Override
    public JsonGenerator setCharacterEscapes(CharacterEscapes characterEscapes) {
        this._characterEscapes = characterEscapes;
        this._outputEscapes = characterEscapes == null ? sOutputEscapes : characterEscapes.getEscapeCodesForAscii();
        return this;
    }

    @Override
    public CharacterEscapes getCharacterEscapes() {
        return this._characterEscapes;
    }

    @Override
    public JsonGenerator setRootValueSeparator(SerializableString serializableString) {
        this._rootValueSeparator = serializableString;
        return this;
    }

    @Override
    public Version version() {
        return VersionUtil.versionFor(this.getClass());
    }

    @Override
    public final void writeStringField(String string, String string2) throws IOException, JsonGenerationException {
        this.writeFieldName(string);
        this.writeString(string2);
    }
}

