/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.commons.httpclient;

import okhttp3.OkHttpClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientConnectionManagerFactory;
import org.springframework.cloud.commons.httpclient.ApacheHttpClientFactory;
import org.springframework.cloud.commons.httpclient.DefaultApacheHttpClientConnectionManagerFactory;
import org.springframework.cloud.commons.httpclient.DefaultApacheHttpClientFactory;
import org.springframework.cloud.commons.httpclient.DefaultOkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.DefaultOkHttpClientFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientConnectionPoolFactory;
import org.springframework.cloud.commons.httpclient.OkHttpClientFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HttpClientConfiguration {

    @Configuration
    @ConditionalOnProperty(name={"spring.cloud.httpclientfactories.ok.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(value={OkHttpClient.class})
    static class OkHttpClientConfiguration {
        OkHttpClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public OkHttpClientConnectionPoolFactory connPoolFactory() {
            return new DefaultOkHttpClientConnectionPoolFactory();
        }

        @Bean
        @ConditionalOnMissingBean
        public OkHttpClientFactory okHttpClientFactory() {
            return new DefaultOkHttpClientFactory();
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"spring.cloud.httpclientfactories.apache.enabled"}, matchIfMissing=true)
    static class ApacheHttpClientConfiguration {
        ApacheHttpClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ApacheHttpClientConnectionManagerFactory connManFactory() {
            return new DefaultApacheHttpClientConnectionManagerFactory();
        }

        @Bean
        @ConditionalOnMissingBean
        public ApacheHttpClientFactory apacheHttpClientFactory() {
            return new DefaultApacheHttpClientFactory();
        }
    }
}

