/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.scope;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.cloud.context.config.BeanLifecycleDecorator;
import org.springframework.cloud.context.config.StandardBeanLifecycleDecorator;
import org.springframework.cloud.context.scope.ScopeCache;
import org.springframework.cloud.context.scope.StandardScopeCache;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class GenericScope
implements Scope,
BeanFactoryPostProcessor,
DisposableBean {
    private static final Log logger = LogFactory.getLog(GenericScope.class);
    private BeanLifecycleWrapperCache cache = new BeanLifecycleWrapperCache(new StandardScopeCache());
    private String name = "generic";
    private boolean proxyTargetClass = true;
    private boolean autoProxy = true;
    private ConfigurableListableBeanFactory beanFactory;
    private StandardEvaluationContext evaluationContext;
    private String id;
    private BeanLifecycleDecorator<?> lifecycle;

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProxyTargetClass(boolean proxyTargetClass) {
        this.proxyTargetClass = proxyTargetClass;
    }

    public void setAutoProxy(boolean autoProxy) {
        this.autoProxy = autoProxy;
    }

    public void setScopeCache(ScopeCache cache) {
        this.cache = new BeanLifecycleWrapperCache(cache);
    }

    public void setBeanLifecycleManager(BeanLifecycleDecorator<?> lifecycle) {
        this.lifecycle = lifecycle;
    }

    public void destroy() {
        ArrayList<RuntimeException> errors = new ArrayList<RuntimeException>();
        Collection<BeanLifecycleWrapper> wrappers = this.cache.clear();
        for (BeanLifecycleWrapper wrapper : wrappers) {
            try {
                wrapper.destroy();
            }
            catch (RuntimeException e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            throw GenericScope.wrapIfNecessary((Throwable)errors.get(0));
        }
    }

    protected void destroy(String name) {
        BeanLifecycleWrapper wrapper = this.cache.remove(name);
        if (wrapper != null) {
            wrapper.destroy();
        }
    }

    public Object get(String name, ObjectFactory<?> objectFactory) {
        if (this.lifecycle == null) {
            this.lifecycle = new StandardBeanLifecycleDecorator(this.proxyTargetClass);
        }
        BeanLifecycleWrapper value = this.cache.put(name, new BeanLifecycleWrapper(name, objectFactory, this.lifecycle));
        return value.getBean();
    }

    public String getConversationId() {
        return this.name;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        BeanLifecycleWrapper value = this.cache.get(name);
        if (value == null) {
            return;
        }
        value.setDestroyCallback(callback);
    }

    public Object remove(String name) {
        BeanLifecycleWrapper value = this.cache.remove(name);
        if (value == null) {
            return null;
        }
        return value.getBean();
    }

    public Object resolveContextualObject(String key) {
        Expression expression = this.parseExpression(key);
        return expression.getValue((EvaluationContext)this.evaluationContext, (Object)this.beanFactory);
    }

    private Expression parseExpression(String input) {
        if (StringUtils.hasText((String)input)) {
            SpelExpressionParser parser = new SpelExpressionParser();
            try {
                return parser.parseExpression(input);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Cannot parse expression: " + input, e);
            }
        }
        return null;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.registerScope(this.name, (Scope)this);
        this.setSerializationId(beanFactory);
        this.beanFactory = beanFactory;
        this.evaluationContext = new StandardEvaluationContext();
        this.evaluationContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        if (!this.autoProxy) {
            return;
        }
        Assert.state((boolean)(beanFactory instanceof BeanDefinitionRegistry), (String)"BeanFactory was not a BeanDefinitionRegistry, so RefreshScope cannot be used.");
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        String[] stringArray = beanFactory.getBeanDefinitionNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String beanName = stringArray[n2];
            BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
            boolean scoped = this.name.equals(definition.getScope());
            Scopifier scopifier = new Scopifier(registry, this.name, this.proxyTargetClass, scoped);
            scopifier.visitBeanDefinition(definition);
            if (scoped) {
                GenericScope.createScopedProxy(beanName, definition, registry, this.proxyTargetClass);
            }
            ++n2;
        }
    }

    private void setSerializationId(ConfigurableListableBeanFactory beanFactory) {
        if (beanFactory instanceof DefaultListableBeanFactory) {
            String id = this.id;
            if (id == null) {
                String names = Arrays.asList(beanFactory.getBeanDefinitionNames()).toString();
                logger.debug((Object)("Generating bean factory id from names: " + names));
                id = UUID.nameUUIDFromBytes(names.getBytes()).toString();
            }
            logger.info((Object)("BeanFactory id=" + id));
            ((DefaultListableBeanFactory)beanFactory).setSerializationId(id);
        } else {
            logger.warn((Object)"BeanFactory was not a DefaultListableBeanFactory, so RefreshScope beans cannot be serialized reliably and passed to a remote JVM.");
        }
    }

    static RuntimeException wrapIfNecessary(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return new IllegalStateException(throwable);
    }

    private static BeanDefinitionHolder createScopedProxy(String beanName, BeanDefinition definition, BeanDefinitionRegistry registry, boolean proxyTargetClass) {
        BeanDefinitionHolder proxyHolder = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)new BeanDefinitionHolder(definition, beanName), (BeanDefinitionRegistry)registry, (boolean)proxyTargetClass);
        registry.registerBeanDefinition(beanName, proxyHolder.getBeanDefinition());
        return proxyHolder;
    }

    private static class BeanLifecycleWrapper {
        private Object bean;
        private BeanLifecycleDecorator.Context<?> context;
        private final String name;
        private final BeanLifecycleDecorator lifecycle;
        private final ObjectFactory<?> objectFactory;

        public BeanLifecycleWrapper(String name, ObjectFactory<?> objectFactory, BeanLifecycleDecorator lifecycle) {
            this.name = name;
            this.objectFactory = objectFactory;
            this.lifecycle = lifecycle;
        }

        public void setDestroyCallback(Runnable callback) {
            this.context = this.lifecycle.decorateDestructionCallback(callback);
        }

        public Object getBean() {
            if (this.bean == null) {
                this.bean = this.lifecycle.decorateBean(this.objectFactory.getObject(), this.context);
            }
            return this.bean;
        }

        public void destroy() {
            if (this.context == null) {
                return;
            }
            Runnable callback = this.context.getCallback();
            if (callback != null) {
                callback.run();
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BeanLifecycleWrapper other = (BeanLifecycleWrapper)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    private static class BeanLifecycleWrapperCache {
        private final ScopeCache cache;

        public BeanLifecycleWrapperCache(ScopeCache cache) {
            this.cache = cache;
        }

        public BeanLifecycleWrapper remove(String name) {
            return (BeanLifecycleWrapper)this.cache.remove(name);
        }

        public Collection<BeanLifecycleWrapper> clear() {
            Collection<Object> values = this.cache.clear();
            LinkedHashSet<BeanLifecycleWrapper> wrappers = new LinkedHashSet<BeanLifecycleWrapper>();
            for (Object object : values) {
                wrappers.add((BeanLifecycleWrapper)object);
            }
            return wrappers;
        }

        public BeanLifecycleWrapper get(String name) {
            return (BeanLifecycleWrapper)this.cache.get(name);
        }

        public BeanLifecycleWrapper put(String name, BeanLifecycleWrapper value) {
            return (BeanLifecycleWrapper)this.cache.put(name, value);
        }
    }

    private static class Scopifier
    extends BeanDefinitionVisitor {
        private final boolean proxyTargetClass;
        private final BeanDefinitionRegistry registry;
        private final String scope;
        private final boolean scoped;

        public Scopifier(BeanDefinitionRegistry registry, String scope, boolean proxyTargetClass, boolean scoped) {
            super(new StringValueResolver(){

                public String resolveStringValue(String value) {
                    return value;
                }
            });
            this.registry = registry;
            this.proxyTargetClass = proxyTargetClass;
            this.scope = scope;
            this.scoped = scoped;
        }

        protected Object resolveValue(Object value) {
            BeanDefinition definition = null;
            String beanName = null;
            if (value instanceof BeanDefinition) {
                definition = (BeanDefinition)value;
                beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)definition, (BeanDefinitionRegistry)this.registry);
            } else if (value instanceof BeanDefinitionHolder) {
                BeanDefinitionHolder holder = (BeanDefinitionHolder)value;
                definition = holder.getBeanDefinition();
                beanName = holder.getBeanName();
            }
            if (definition != null) {
                boolean scopeChangeRequiresProxy;
                boolean nestedScoped = this.scope.equals(definition.getScope());
                boolean bl = scopeChangeRequiresProxy = !this.scoped && nestedScoped;
                if (scopeChangeRequiresProxy) {
                    return GenericScope.createScopedProxy(beanName, definition, this.registry, this.proxyTargetClass);
                }
            }
            value = super.resolveValue(value);
            return value;
        }
    }
}

