/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.client;

import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.cloud.config.client.ConfigServerHealthIndicator;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class ConfigClientAutoConfiguration {
    @Bean
    public ConfigClientProperties configClientProperties(Environment environment, ApplicationContext context) {
        if (context.getParent() != null && BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getParent(), ConfigClientProperties.class).length > 0) {
            return (ConfigClientProperties)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)context.getParent(), ConfigClientProperties.class);
        }
        ConfigClientProperties client = new ConfigClientProperties(environment);
        return client;
    }

    @Configuration
    @ConditionalOnClass(value={HealthIndicator.class})
    @ConditionalOnBean(value={ConfigServicePropertySourceLocator.class})
    @ConditionalOnProperty(value={"health.config.enabled"}, matchIfMissing=true)
    protected static class ConfigServerHealthIndicatorConfiguration {
        protected ConfigServerHealthIndicatorConfiguration() {
        }

        @Bean
        public ConfigServerHealthIndicator configServerHealthIndicator(ConfigServicePropertySourceLocator locator) {
            return new ConfigServerHealthIndicator(locator);
        }
    }

    @ConfigurationProperties(value="health.config")
    public static class Health {
        boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

