/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.monitor;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.config.monitor.PropertyPathEndpoint;
import org.springframework.cloud.config.server.environment.AbstractScmEnvironmentRepository;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepository;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpHeaders;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.PatternMatchUtils;

@Configuration
@EnableScheduling
public class FileMonitorConfiguration
implements SmartLifecycle,
ResourceLoaderAware {
    private static final Log log = LogFactory.getLog(FileMonitorConfiguration.class);
    @Autowired
    PropertyPathEndpoint endpoint;
    @Autowired(required=false)
    AbstractScmEnvironmentRepository scmRepository;
    @Autowired(required=false)
    NativeEnvironmentRepository nativeEnvironmentRepository;
    private boolean running;
    private WatchService watcher;
    private Set<Path> directory;
    private int phase;
    private boolean autoStartup = true;
    private ResourceLoader resourceLoader;
    private String[] excludes = new String[]{".*", "#*", "*#"};

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public synchronized void start() {
        if (!this.running) {
            this.directory = this.getFileRepo();
            if (this.directory != null && !this.directory.isEmpty()) {
                log.info((Object)("Monitoring for local config changes: " + this.directory));
                try {
                    this.watcher = FileSystems.getDefault().newWatchService();
                    for (Path path : this.directory) {
                        this.walkDirectory(path);
                    }
                }
                catch (IOException iOException) {}
            } else {
                log.info((Object)"Not monitoring for local config changes");
            }
            this.running = true;
        }
    }

    public synchronized void stop() {
        if (this.running) {
            if (this.watcher != null) {
                try {
                    this.watcher.close();
                }
                catch (IOException e) {
                    log.error((Object)("Failed to close watcher for " + this.directory.toString()), (Throwable)e);
                }
            }
            this.running = false;
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    @Scheduled(fixedRateString="${spring.cloud.config.server.monitor.fixedDelay:5000}")
    public void poll() {
        for (File file : this.filesFromEvents()) {
            this.endpoint.notifyByPath(new HttpHeaders(), Collections.singletonMap("path", file.getAbsolutePath()));
        }
    }

    private Set<Path> getFileRepo() {
        if (this.scmRepository != null && this.scmRepository.getUri().startsWith("file:")) {
            try {
                return Collections.singleton(Paths.get(this.resourceLoader.getResource(this.scmRepository.getUri()).getURI()));
            }
            catch (IOException e) {
                log.error((Object)("Cannot resolve URI for path: " + this.scmRepository.getUri()));
            }
        }
        if (this.nativeEnvironmentRepository != null) {
            LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
            for (String path : this.nativeEnvironmentRepository.getSearchLocations()) {
                Resource resource = this.resourceLoader.getResource(path);
                if (!resource.exists()) continue;
                try {
                    paths.add(Paths.get(resource.getURI()));
                }
                catch (IOException e) {
                    log.error((Object)("Cannot resolve URI for path: " + path));
                }
            }
            return paths;
        }
        return null;
    }

    private Set<File> filesFromEvents() {
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        if (this.watcher == null) {
            return files;
        }
        WatchKey key = this.watcher.poll();
        while (key != null) {
            for (WatchEvent<?> event : key.pollEvents()) {
                if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE || event.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                    Path item = (Path)event.context();
                    File file = new File(((Path)key.watchable()).toAbsolutePath() + File.separator + item.getFileName());
                    if (file.isDirectory()) {
                        files.addAll(this.walkDirectory(file.toPath()));
                        continue;
                    }
                    if (file.getPath().contains(".git") || PatternMatchUtils.simpleMatch((String[])this.excludes, (String)file.getName())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Watch Event: " + event.kind() + ": " + file));
                    }
                    files.add(file);
                    continue;
                }
                if (event.kind() == StandardWatchEventKinds.OVERFLOW) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Watch Event: " + event.kind() + ": context: " + event.context()));
                    }
                    if (event.context() != null && event.context() instanceof Path) {
                        files.addAll(this.walkDirectory((Path)event.context()));
                        continue;
                    }
                    for (Path path : this.directory) {
                        files.addAll(this.walkDirectory(path));
                    }
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Watch Event: " + event.kind() + ": context: " + event.context()));
            }
            key.reset();
            key = this.watcher.poll();
        }
        return files;
    }

    private Set<File> walkDirectory(Path directory) {
        final LinkedHashSet<File> walkedFiles = new LinkedHashSet<File>();
        try {
            this.registerWatch(directory);
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    FileVisitResult fileVisitResult = super.preVisitDirectory(dir, attrs);
                    if (dir.toFile().getPath().contains(".git")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    FileMonitorConfiguration.this.registerWatch(dir);
                    return fileVisitResult;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    FileVisitResult fileVisitResult = super.visitFile(file, attrs);
                    walkedFiles.add(file.toFile());
                    return fileVisitResult;
                }
            });
        }
        catch (IOException e) {
            log.error((Object)("Failed to walk directory: " + directory.toString()), (Throwable)e);
        }
        return walkedFiles;
    }

    private void registerWatch(Path dir) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("registering: " + dir + " for file creation events"));
        }
        dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
    }
}

