/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.server.ConfigServerProperties;
import org.springframework.cloud.config.server.EnvironmentRepository;
import org.springframework.cloud.config.server.MultipleJGitEnvironmentRepository;
import org.springframework.cloud.config.server.SpringApplicationEnvironmentRepository;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@ConditionalOnMissingBean(value={EnvironmentRepository.class})
@EnableConfigurationProperties(value={ConfigServerProperties.class})
public class ConfigServerConfiguration {

    @Configuration
    @Profile(value={"!native"})
    protected static class GitRepositoryConfiguration {
        @Autowired
        private ConfigurableEnvironment environment;

        protected GitRepositoryConfiguration() {
        }

        @Bean
        public MultipleJGitEnvironmentRepository EnvironmentRepository() {
            return new MultipleJGitEnvironmentRepository(this.environment);
        }
    }

    @Configuration
    @Profile(value={"native"})
    protected static class NativeRepositoryConfiguration {
        protected NativeRepositoryConfiguration() {
        }

        @Bean
        public SpringApplicationEnvironmentRepository EnvironmentRepository() {
            return new SpringApplicationEnvironmentRepository();
        }
    }
}

