/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.File;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.config.server.environment.AbstractScmEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.NoSuchLabelException;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc2.SvnCheckout;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.core.wc2.SvnUpdate;

@ConfigurationProperties(value="spring.cloud.config.server.svn")
public class SvnKitEnvironmentRepository
extends AbstractScmEnvironmentRepository
implements EnvironmentRepository,
InitializingBean {
    private static Log logger = LogFactory.getLog(SvnKitEnvironmentRepository.class);
    private static final String DEFAULT_LABEL = "trunk";
    private String defaultLabel = "trunk";

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    @Override
    public synchronized SearchPathLocator.Locations getLocations(String application, String profile, String label) {
        if (label == null) {
            label = this.defaultLabel;
        }
        SvnOperationFactory svnOperationFactory = new SvnOperationFactory();
        if (StringUtils.hasText((String)this.getUsername())) {
            svnOperationFactory.setAuthenticationManager((ISVNAuthenticationManager)new DefaultSVNAuthenticationManager(null, false, this.getUsername(), this.getPassword()));
        }
        try {
            String version = new File(this.getWorkingDirectory(), ".svn").exists() ? this.update(svnOperationFactory, label) : this.checkout(svnOperationFactory);
            SearchPathLocator.Locations locations = new SearchPathLocator.Locations(application, profile, label, version, this.getPaths(application, profile, label));
            return locations;
        }
        catch (SVNException e) {
            throw new IllegalStateException("Cannot checkout repository", e);
        }
        finally {
            svnOperationFactory.dispose();
        }
    }

    private String[] getPaths(String application, String profile, String label) {
        String[] locations = this.getSearchLocations(this.getSvnPath(this.getWorkingDirectory(), label), application, profile, label);
        boolean exists = false;
        for (String location : locations) {
            URI locationUri = URI.create(location = StringUtils.cleanPath((String)location));
            if (!new File(locationUri).exists()) continue;
            exists = true;
            break;
        }
        if (!exists) {
            throw new NoSuchLabelException("No label found for: " + label);
        }
        return locations;
    }

    private String checkout(SvnOperationFactory svnOperationFactory) throws SVNException {
        logger.debug((Object)("Checking out " + this.getUri() + " to: " + this.getWorkingDirectory().getAbsolutePath()));
        SvnCheckout checkout = svnOperationFactory.createCheckout();
        checkout.setSource(SvnTarget.fromURL((SVNURL)SVNURL.parseURIEncoded((String)this.getUri())));
        checkout.setSingleTarget(SvnTarget.fromFile((File)this.getWorkingDirectory()));
        Long id = (Long)checkout.run();
        if (id == null) {
            return null;
        }
        return id.toString();
    }

    private String update(SvnOperationFactory svnOperationFactory, String label) throws SVNException {
        logger.debug((Object)"Repo already checked out - updating instead.");
        try {
            SvnUpdate update = svnOperationFactory.createUpdate();
            update.setSingleTarget(SvnTarget.fromFile((File)this.getWorkingDirectory()));
            long[] ids = (long[])update.run();
            StringBuilder version = new StringBuilder();
            for (long id : ids) {
                if (version.length() > 0) {
                    version.append(",");
                }
                version.append(id);
            }
            return version.toString();
        }
        catch (Exception e) {
            logger.warn((Object)("Could not update remote for " + label + " (current local=" + this.getWorkingDirectory().getPath() + "), remote: " + this.getUri() + ")"));
            SVNStatus status = SVNClientManager.newInstance().getStatusClient().doStatus(this.getWorkingDirectory(), false);
            return status != null ? status.getRevision().toString() : null;
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.getUri() != null ? 1 : 0) != 0, (String)"You need to configure a uri for the subversion repository (e.g. 'http://example.com/svn/')");
        this.resolveRelativeFileUri();
    }

    private void resolveRelativeFileUri() {
        if (this.getUri().startsWith("file:///./")) {
            String path = this.getUri().substring(8);
            String absolutePath = new File(path).getAbsolutePath();
            this.setUri("file:///" + StringUtils.cleanPath((String)absolutePath));
        }
    }

    public SvnKitEnvironmentRepository(ConfigurableEnvironment environment) {
        super(environment);
    }

    @Override
    protected File getWorkingDirectory() {
        return this.getBasedir();
    }

    private File getSvnPath(File workingDirectory, String label) {
        return new File(workingDirectory, label);
    }
}

