/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.server.ssh.PropertyBasedSshSessionFactory;
import org.springframework.cloud.config.server.ssh.SshUriProperties;
import org.springframework.cloud.config.server.ssh.SshUriPropertyProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={TransportConfigCallback.class})
@EnableConfigurationProperties(value={SshUriProperties.class})
public class TransportConfiguration {
    @ConditionalOnMissingBean(value={TransportConfigCallback.class})
    @Bean
    public TransportConfigCallback propertiesBasedSshTransportCallback(SshUriProperties sshUriProperties) {
        if (sshUriProperties.isIgnoreLocalSshSettings()) {
            return new PropertiesBasedSshTransportConfigCallback(sshUriProperties);
        }
        return new FileBasedSshTransportConfigCallback(sshUriProperties);
    }

    public static class FileBasedSshTransportConfigCallback
    implements TransportConfigCallback {
        private SshUriProperties sshUriProperties;

        public FileBasedSshTransportConfigCallback(SshUriProperties sshUriProperties) {
            this.sshUriProperties = sshUriProperties;
        }

        public SshUriProperties getSshUriProperties() {
            return this.sshUriProperties;
        }

        public void configure(Transport transport) {
            SshSessionFactory.setInstance((SshSessionFactory)new JschConfigSessionFactory(){

                protected void configure(OpenSshConfig.Host hc, Session session) {
                    session.setConfig("StrictHostKeyChecking", sshUriProperties.isStrictHostKeyChecking() ? "yes" : "no");
                }
            });
        }
    }

    public static class PropertiesBasedSshTransportConfigCallback
    implements TransportConfigCallback {
        private SshUriProperties sshUriProperties;

        public PropertiesBasedSshTransportConfigCallback(SshUriProperties sshUriProperties) {
            this.sshUriProperties = sshUriProperties;
        }

        public SshUriProperties getSshUriProperties() {
            return this.sshUriProperties;
        }

        public void configure(Transport transport) {
            if (transport instanceof SshTransport) {
                SshTransport sshTransport = (SshTransport)transport;
                sshTransport.setSshSessionFactory((SshSessionFactory)new PropertyBasedSshSessionFactory(new SshUriPropertyProcessor(this.sshUriProperties).getSshKeysByHostname(), new JSch()));
            }
        }
    }
}

