/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.transport.http.apache.HttpClientConnection;
import org.springframework.cloud.config.server.environment.ConfigurableHttpConnectionFactory;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.support.HttpClientSupport;

public class HttpClientConfigurableHttpConnectionFactory
implements ConfigurableHttpConnectionFactory {
    private Map<String, HttpClientBuilder> httpClientsByUri = new HashMap<String, HttpClientBuilder>();

    @Override
    public void addConfiguration(MultipleJGitEnvironmentProperties environmentProperties) throws GeneralSecurityException {
        this.addHttpClient(environmentProperties);
        for (JGitEnvironmentProperties jGitEnvironmentProperties : environmentProperties.getRepos().values()) {
            this.addHttpClient(jGitEnvironmentProperties);
        }
    }

    public HttpConnection create(URL url) throws IOException {
        return this.create(url, null);
    }

    public HttpConnection create(URL url, Proxy proxy) throws IOException {
        return new HttpClientConnection(url.toString(), proxy, (HttpClient)this.lookupHttpClientBuilder(url).build());
    }

    private void addHttpClient(JGitEnvironmentProperties properties) throws GeneralSecurityException {
        if (properties.getUri().startsWith("http")) {
            this.httpClientsByUri.put(properties.getUri(), HttpClientSupport.builder(properties));
        }
    }

    private HttpClientBuilder lookupHttpClientBuilder(URL url) throws MalformedURLException {
        String spec = url.toString();
        HttpClientBuilder builder = this.httpClientsByUri.get(spec);
        while (builder == null) {
            spec = spec.substring(0, spec.lastIndexOf(File.separator));
            builder = this.httpClientsByUri.get(spec);
        }
        return builder;
    }
}

