/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment.vault;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.config.server.environment.AbstractVaultEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentWatch;
import org.springframework.cloud.config.server.environment.VaultEnvironmentProperties;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.vault.core.VaultKeyValueOperations;
import org.springframework.vault.support.VaultResponse;

@Validated
public class SpringVaultEnvironmentRepository
extends AbstractVaultEnvironmentRepository {
    private VaultKeyValueOperations keyValueTemplate;
    private final ObjectMapper objectMapper;
    private String path = "";

    public SpringVaultEnvironmentRepository(ObjectProvider<HttpServletRequest> request, EnvironmentWatch watch, VaultEnvironmentProperties properties, VaultKeyValueOperations keyValueTemplate) {
        super(request, watch, properties);
        this.keyValueTemplate = keyValueTemplate;
        if (properties.getKvVersion() == 2 && StringUtils.hasText((String)properties.getPathToKey())) {
            this.path = properties.getPathToKey() + "/";
        }
        this.objectMapper = new ObjectMapper();
    }

    @Override
    protected String read(String key) {
        VaultResponse response = this.keyValueTemplate.get(this.path + key);
        if (response != null) {
            try {
                return this.objectMapper.writeValueAsString(response.getData());
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Error creating Vault response", e);
            }
        }
        return null;
    }

    public VaultKeyValueOperations getKeyValueTemplate() {
        return this.keyValueTemplate;
    }
}

