/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Collection;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceLoader;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.io.resource.AbstractIoResource;
import org.apache.sshd.common.util.io.resource.IoResource;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.springframework.util.StringUtils;

final class KeyPairUtils {
    private static final KeyPairResourceLoader loader = SecurityUtils.getKeyPairResourceParser();

    private KeyPairUtils() {
    }

    static Collection<KeyPair> load(SessionContext session, String privateKey, String passphrase) throws IOException, GeneralSecurityException {
        FilePasswordProvider passwordProvider = StringUtils.hasText((String)passphrase) ? FilePasswordProvider.of((String)passphrase) : FilePasswordProvider.EMPTY;
        return loader.loadKeyPairs(session, (IoResource)new StringResource(privateKey), passwordProvider);
    }

    static boolean isValid(String privateKey, String passphrase) {
        try {
            return !KeyPairUtils.load(null, privateKey, passphrase).isEmpty();
        }
        catch (IOException | GeneralSecurityException ignored) {
            return false;
        }
    }

    private static class StringResource
    extends AbstractIoResource<String> {
        protected StringResource(String resourceValue) {
            super(String.class, (Object)resourceValue);
        }

        public InputStream openInputStream() {
            return new ByteArrayInputStream(((String)this.getResourceValue()).getBytes());
        }
    }
}

