/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.config;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.consul.config.ConsulConfigProperties;
import org.springframework.cloud.consul.config.ConsulFilesPropertySource;
import org.springframework.cloud.consul.config.ConsulPropertySource;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.retry.annotation.Retryable;
import org.springframework.util.ReflectionUtils;

@Order(value=0)
public class ConsulPropertySourceLocator
implements PropertySourceLocator {
    private static final Log log = LogFactory.getLog(ConsulPropertySourceLocator.class);
    private ConsulClient consul;
    private ConsulConfigProperties properties;
    private List<String> contexts = new ArrayList<String>();

    public ConsulPropertySourceLocator(ConsulClient consul, ConsulConfigProperties properties) {
        this.consul = consul;
        this.properties = properties;
    }

    public List<String> getContexts() {
        return this.contexts;
    }

    @Retryable(interceptor="consulRetryInterceptor")
    public PropertySource<?> locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            String appName = env.getProperty("spring.application.name");
            List<String> profiles = Arrays.asList(env.getActiveProfiles());
            String prefix = this.properties.getPrefix();
            ArrayList<String> suffixes = new ArrayList<String>();
            if (this.properties.getFormat() != ConsulConfigProperties.Format.FILES) {
                suffixes.add("/");
            } else {
                suffixes.add(".yml");
                suffixes.add(".yaml");
                suffixes.add(".properties");
            }
            String defaultContext = prefix + "/" + this.properties.getDefaultContext();
            for (String string : suffixes) {
                this.contexts.add(defaultContext + string);
            }
            for (String string : suffixes) {
                this.addProfiles(this.contexts, defaultContext, profiles, string);
            }
            String baseContext = prefix + "/" + appName;
            for (String suffix : suffixes) {
                this.contexts.add(baseContext + suffix);
            }
            for (String suffix : suffixes) {
                this.addProfiles(this.contexts, baseContext, profiles, suffix);
            }
            Collections.reverse(this.contexts);
            CompositePropertySource compositePropertySource = new CompositePropertySource("consul");
            for (String propertySourceContext : this.contexts) {
                try {
                    ConsulPropertySource propertySource = null;
                    if (this.properties.getFormat() == ConsulConfigProperties.Format.FILES) {
                        Response response = this.consul.getKVValue(propertySourceContext, this.properties.getAclToken());
                        if (response.getValue() != null) {
                            ConsulFilesPropertySource filesPropertySource = new ConsulFilesPropertySource(propertySourceContext, this.consul, this.properties);
                            filesPropertySource.init((GetValue)response.getValue());
                            propertySource = filesPropertySource;
                        }
                    } else {
                        propertySource = this.create(propertySourceContext);
                    }
                    if (propertySource == null) continue;
                    compositePropertySource.addPropertySource((PropertySource)propertySource);
                }
                catch (Exception e) {
                    if (this.properties.isFailFast()) {
                        log.error((Object)"Fail fast is set and there was an error reading configuration from consul.");
                        ReflectionUtils.rethrowRuntimeException((Throwable)e);
                        continue;
                    }
                    log.warn((Object)("Unable to load consul config from " + propertySourceContext), (Throwable)e);
                }
            }
            return compositePropertySource;
        }
        return null;
    }

    private ConsulPropertySource create(String context) {
        ConsulPropertySource propertySource = new ConsulPropertySource(context, this.consul, this.properties);
        propertySource.init();
        return propertySource;
    }

    private void addProfiles(List<String> contexts, String baseContext, List<String> profiles, String suffix) {
        for (String profile : profiles) {
            contexts.add(baseContext + this.properties.getProfileSeparator() + profile + suffix);
        }
    }
}

