/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.serviceregistry;

import com.ecwid.consul.ConsulException;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.health.model.Check;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.health.Status;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.discovery.TtlScheduler;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.util.ReflectionUtils;

public class ConsulServiceRegistry
implements ServiceRegistry<ConsulRegistration> {
    private static Log log = LogFactory.getLog(ConsulServiceRegistry.class);
    private final ConsulClient client;
    private final ConsulDiscoveryProperties properties;
    private final TtlScheduler ttlScheduler;
    private final HeartbeatProperties heartbeatProperties;

    public ConsulServiceRegistry(ConsulClient client, ConsulDiscoveryProperties properties, TtlScheduler ttlScheduler, HeartbeatProperties heartbeatProperties) {
        this.client = client;
        this.properties = properties;
        this.ttlScheduler = ttlScheduler;
        this.heartbeatProperties = heartbeatProperties;
    }

    public void register(ConsulRegistration reg) {
        log.info((Object)("Registering service with consul: " + reg.getService()));
        try {
            this.client.agentServiceRegister(reg.getService(), this.properties.getAclToken());
            if (this.heartbeatProperties.isEnabled() && this.ttlScheduler != null) {
                this.ttlScheduler.add(reg.getInstanceId());
            }
        }
        catch (ConsulException e) {
            if (this.properties.isFailFast()) {
                log.error((Object)("Error registering service with consul: " + reg.getService()), (Throwable)e);
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
            log.warn((Object)("Failfast is false. Error registering service with consul: " + reg.getService()), (Throwable)e);
        }
    }

    public void deregister(ConsulRegistration reg) {
        if (this.ttlScheduler != null) {
            this.ttlScheduler.remove(reg.getInstanceId());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Deregistering service with consul: " + reg.getInstanceId()));
        }
        this.client.agentServiceDeregister(reg.getInstanceId(), this.properties.getAclToken());
    }

    public void close() {
    }

    public void setStatus(ConsulRegistration registration, String status) {
        if (status.equalsIgnoreCase(Status.OUT_OF_SERVICE.getCode())) {
            this.client.agentServiceSetMaintenance(registration.getInstanceId(), true);
        } else if (status.equalsIgnoreCase(Status.UP.getCode())) {
            this.client.agentServiceSetMaintenance(registration.getInstanceId(), false);
        } else {
            throw new IllegalArgumentException("Unknown status: " + status);
        }
    }

    public Object getStatus(ConsulRegistration registration) {
        String serviceId = registration.getServiceId();
        Response response = this.client.getHealthChecksForService(serviceId, QueryParams.DEFAULT);
        List checks = (List)response.getValue();
        for (Check check : checks) {
            if (!check.getServiceId().equals(registration.getInstanceId()) || !check.getName().equalsIgnoreCase("Service Maintenance Mode")) continue;
            return Status.OUT_OF_SERVICE.getCode();
        }
        return Status.UP.getCode();
    }
}

