/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.discovery.configclient;

import com.ecwid.consul.v1.ConsulClient;
import java.util.Collections;
import java.util.function.Supplier;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.BootstrapRegistryInitializer;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;
import org.springframework.cloud.config.client.ConfigServerConfigDataLocationResolver;
import org.springframework.cloud.config.client.ConfigServerInstanceProvider;
import org.springframework.cloud.consul.ConsulAutoConfiguration;
import org.springframework.cloud.consul.ConsulProperties;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.util.ClassUtils;

public class ConsulConfigServerBootstrapper
implements BootstrapRegistryInitializer {
    public void initialize(BootstrapRegistry registry) {
        if (!ClassUtils.isPresent((String)"org.springframework.cloud.config.client.ConfigServerInstanceProvider", null) || ClassUtils.isPresent((String)"org.springframework.cloud.bootstrap.marker.Marker", null)) {
            return;
        }
        registry.registerIfAbsent(ConsulProperties.class, context -> {
            if (!ConsulConfigServerBootstrapper.isDiscoveryEnabled(context)) {
                return null;
            }
            ConfigServerConfigDataLocationResolver.PropertyResolver propertyResolver = ConsulConfigServerBootstrapper.getPropertyResolver(context);
            return (ConsulProperties)propertyResolver.resolveConfigurationProperties("spring.cloud.consul", ConsulProperties.class, ConsulProperties::new);
        });
        registry.registerIfAbsent(ConsulClient.class, context -> {
            if (!ConsulConfigServerBootstrapper.isDiscoveryEnabled(context)) {
                return null;
            }
            ConsulProperties consulProperties = (ConsulProperties)context.get(ConsulProperties.class);
            return ConsulAutoConfiguration.createConsulClient((ConsulProperties)consulProperties, (Supplier)ConsulAutoConfiguration.createConsulRawClientBuilder());
        });
        registry.registerIfAbsent(ConsulDiscoveryClient.class, context -> {
            if (!ConsulConfigServerBootstrapper.isDiscoveryEnabled(context)) {
                return null;
            }
            ConfigServerConfigDataLocationResolver.PropertyResolver propertyResolver = ConsulConfigServerBootstrapper.getPropertyResolver(context);
            ConsulClient consulClient = (ConsulClient)context.get(ConsulClient.class);
            ConsulDiscoveryProperties properties = (ConsulDiscoveryProperties)propertyResolver.resolveConfigurationProperties("spring.cloud.consul.discovery", ConsulDiscoveryProperties.class, () -> new ConsulDiscoveryProperties(new InetUtils(new InetUtilsProperties())));
            return new ConsulDiscoveryClient(consulClient, properties);
        });
        registry.addCloseListener(event -> {
            if (!ConsulConfigServerBootstrapper.isDiscoveryEnabled(event.getBootstrapContext())) {
                return;
            }
            ConsulDiscoveryClient discoveryClient = (ConsulDiscoveryClient)event.getBootstrapContext().get(ConsulDiscoveryClient.class);
            if (discoveryClient != null) {
                event.getApplicationContext().getBeanFactory().registerSingleton("consulDiscoveryClient", (Object)discoveryClient);
            }
        });
        registry.registerIfAbsent(ConfigServerInstanceProvider.Function.class, context -> {
            if (!ConsulConfigServerBootstrapper.isDiscoveryEnabled(context)) {
                return id -> Collections.emptyList();
            }
            ConsulDiscoveryClient discoveryClient = (ConsulDiscoveryClient)context.get(ConsulDiscoveryClient.class);
            return discoveryClient::getInstances;
        });
    }

    private static ConfigServerConfigDataLocationResolver.PropertyResolver getPropertyResolver(BootstrapContext context) {
        return (ConfigServerConfigDataLocationResolver.PropertyResolver)context.getOrElseSupply(ConfigServerConfigDataLocationResolver.PropertyResolver.class, () -> new ConfigServerConfigDataLocationResolver.PropertyResolver((Binder)context.get(Binder.class), (BindHandler)context.getOrElse(BindHandler.class, null)));
    }

    public static boolean isDiscoveryEnabled(BootstrapContext bootstrapContext) {
        ConfigServerConfigDataLocationResolver.PropertyResolver propertyResolver = ConsulConfigServerBootstrapper.getPropertyResolver(bootstrapContext);
        return (Boolean)propertyResolver.get("spring.cloud.config.discovery.enabled", Boolean.class, (Object)false) != false && (Boolean)propertyResolver.get("spring.cloud.consul.discovery.enabled", Boolean.class, (Object)true) != false && (Boolean)propertyResolver.get("spring.cloud.discovery.enabled", Boolean.class, (Object)true) != false;
    }
}

